% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UVic.R
\docType{data}
\name{uvic_core}
\alias{uvic_core}
\title{Core colours of University of Victoria, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on the
\href{https://www.uvic.ca/brand/look-feel/colour/palette/}{Core Palette}.
}
\usage{
uvic_core
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{uvic_core} provides four core colours 
of \href{https://www.uvic.ca/}{University of Victoria}, Canada.
}
\details{
The 4 core UVic colours can be used in various combinations 
depending on audience and medium. The dominant colours are blue and yellow, 
with red used as an accent colour. Dark blue works well as a background and 
type colour. The core colours have to be present on all external communications 
and marketing materials to establish and build recognition by association.

The 4 core colours are 
\code{"uvic_blue"} (defined as HEX #005493 or RGB 0/94/184), 
\code{"uvic_yellow"} (defined as HEX #F5AA1C or RGB 234/170/0),
\code{"uvic_red"} (defined as HEX #C63527 or RGB 210/38/48), and
\code{"uvic_dark_blue"} (defined as HEX #002754 or RGB 0/46/93).

HEX colour definitions are used for web, 
RGB colour definitions are used for electronic displays.

\code{uvic_core} is based on the HEX colour definitions.
}
\examples{
uvic_core
unikn::seecol(uvic_core, main = "UVic core palette") # view colour palette

}
\seealso{
\code{\link{uvic_complementary}} for the complementary colour palette of University of Victoria;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
