% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Macquarie.R
\docType{data}
\name{mq_2}
\alias{mq_2}
\title{Faculty colors of Macquarie University, Australia}
\format{
An object of class \code{character} of length 4.
}
\source{
MQ's staff portal page 
\href{https://staff.mq.edu.au/support/marketing-and-communications/brand-guidelines/colours-and-light-graphic}{Colours and light graphic}
}
\usage{
mq_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mq_2} provides the four faculty colors 
of \href{https://www.mq.edu.au}{Macquarie University}, located in Sydney, Australia.
}
\details{
\code{mq_2} uses the HEX color definitions.


Faculty colours are reserved for use in the entity device 
and within indexing systems on internal pages.
}
\examples{
mq_2
unikn::seecol(mq_2, main = "Faculty colours of Macquarie University") # view color palette

}
\seealso{
\code{\link{mq_1}} for primary colours of Macquarie University; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{ANU_1}},
\code{\link{ANU_2}},
\code{\link{mq_1}},
\code{\link{wollongong_1}},
\code{\link{wollongong_2}}
}
\author{
\strong{unicol}, 2023-09-05.
}
\concept{Australian university color palettes}
\keyword{datasets}
