% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manitoba.R
\docType{data}
\name{manitoba_2}
\alias{manitoba_2}
\title{Extended colors of the University of Manitoba, Canada}
\format{
An object of class \code{character} of length 13.
}
\source{
Color definitions are based on the
\href{https://umanitoba.ca/sites/default/files/2019-12/UM_Brand-Guidelines.pdf}{Brand Guidelines (PDF)}.
}
\usage{
manitoba_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{manitoba_2} provides the 13 extended color palette colors 
of the \href{https://umanitoba.ca/}{University of Manitoba}, Canada.
}
\details{
The 13 colors are
\code{"PMS_2627"}, (defined as RGB 60/16/83, HEX #3C1053),
\code{"PMS_294"} (defined as RGB 0/47/108, HEX #002F6C),
\code{"PMS_2199"} (defined as RGB 0/187/220, HEX #00BBDC),
\code{"PMS_542"} (defined as RGB 123/175/212, HEX #7BAFD4),
\code{"PMS_560"} (defined as RGB 29/60/52, HEX #1D3C34),
\code{"PMS_562"} (defined as RGB 0/111/98, HEX #006F62),
\code{"PMS_3268"} (defined as RGB 0/171/142, HEX #00AB8E),
\code{"PMS_3255"} (defined as RGB 44/213/196, HEX #2CD5C4),
\code{"PMS_430"} (defined as RGB 124/135/142, HEX #7C878E),
\code{"PMS_416"} (defined as RGB 126/127/116, HEX #7E7F74),
\code{"PMS_158"} (defined as RGB 232/119/34, HEX #E87722),
\code{"PMS_129"} (defined as RGB 243/208/62, HEX #F3D03E), and
\code{"warm_gray"} (defined as RGB 131/120/111, HEX #83786F).


\code{manitoba_2} uses the HEX color definitions.
}
\examples{
manitoba_2
unikn::seecol(manitoba_2, 
              main = "Extended colors of the University of Manitoba") 

}
\seealso{
\code{\link{manitoba_1}} for the primary colors of the University of Manitoba; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-07-12.
}
\concept{Canadian university color palettes}
\keyword{datasets}
