% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edinburgh.R
\docType{data}
\name{edinburgh_1}
\alias{edinburgh_1}
\title{Primary colours of the University of Edinburgh, Scotland/UK}
\format{
An object of class \code{character} of length 11.
}
\source{
Color definitions are based on the
\href{https://gel.ed.ac.uk/foundations/colour/}{CD manual (PDF)}.
}
\usage{
edinburgh_1
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{edinburgh_1} provides the eleven primary colours 
of the \href{https://www.ed.ac.uk}{University of Edinburgh}, Scotland.
}
\details{
The eleven primary colours are
\code{"University Red"} (defined as Hex: D50032, RGB: 213, 0, 50),
\code{"University Blue"} (defined as Hex: 041E42, RGB: 4, 30, 66), 
\code{"Bright Blue"} (defined as Hex: 007288, RGB: 0, 114, 136),
\code{"Bright Pink"} (defined as Hex: D0006F, RGB: 208, 0, 111),
\code{"Purple"} (defined as Hex: 830065, RGB: 131, 0, 101),
\code{"Burgundy"} (defined as Hex: A50034, RGB: 165, 0, 52),
\code{"Dark green"} (defined as Hex: 154734, RGB: 21, 71, 52),
\code{"Jade"} (defined as Hex: 487A7B, RGB: 72, 122, 123),
\code{"Muted Blue"} (defined as Hex: 004F71, RGB: 0, 79, 113),
\code{"Muted brown"} (defined as Hex: 6D4F47, RGB: 109, 79, 71), and
\code{"Spuce grey"} (defined as Hex: 333F48, RGB: 51, 63, 72).

\code{edinburgh_1} uses the HEX color definitions.
}
\examples{
edinburgh_1
unikn::seecol(edinburgh_1, main = "University of Edinburgh") 
# view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colours.

Other university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCSD_1_core}},
\code{\link{UCSD_2_accent}},
\code{\link{UCSD_3_neutral}},
\code{\link{asu_1}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{birmingham_1}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu_1}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{carleton_1}},
\code{\link{chicago_1}},
\code{\link{chicago_2}},
\code{\link{columbia}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{eth_1}},
\code{\link{eth_2}},
\code{\link{eth_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{guelph}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{laval}},
\code{\link{limerick_1}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_2}},
\code{\link{mit_pal}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{mpg_pal}},
\code{\link{msu_pal}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ottawa_1}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{queens_1}},
\code{\link{queens_2}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{sfu_brand}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{toronto_1}},
\code{\link{trinity_1}},
\code{\link{ubc_1}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_primary}},
\code{\link{ucalgary_secondary}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uci_1}},
\code{\link{uflorida_1}},
\code{\link{umass_2}},
\code{\link{umass_brand}},
\code{\link{umass_neutrals}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg_1}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_manchester_1}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_2_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_3}},
\code{\link{waikato}},
\code{\link{western_uni_1}},
\code{\link{yale_1}},
\code{\link{yeshiva}},
\code{\link{york1}},
\code{\link{york2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{university color palettes}
\keyword{datasets}
