% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Florida.R
\docType{data}
\name{uflorida_3}
\alias{uflorida_3}
\title{Neutral colors of the University of Florida, USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on the 
\href{https://brandcenter.ufl.edu/colors/}{UFL brand center}.
}
\usage{
uflorida_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uflorida_3} provides the five neutral colors 
of the \href{https://www.ufl.edu/}{University of Florida}, USA.
}
\details{
The 5 neutral colors are 
\code{"black"} (defined as HEX #000000),
\code{"ufl_cool_grey_11"} (defined as HEX #343741),
\code{"ufl_cool_grey_3"} (defined as HEX #C7C9C8),
\code{"ufl_warm_grey_1"} (defined as HEX #D8D4D7), and 
\code{"white"} (defined as HEX #FFFFFF).

\code{uflorida_3} uses the HEX color definitions.
}
\examples{
uflorida_3
unikn::seecol(uflorida_3, main = "University of Florida 3") # view color palette

}
\seealso{
\code{\link{uflorida_1}} for primary colors of the University of Florida;
\code{\link{uflorida_2}} for secondary colors of the University of Florida; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.
}
\author{
\strong{unicol}, 2023-07-08.
}
\keyword{datasets}
