% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unfolding.R
\name{em.spheroids}
\alias{em.spheroids}
\title{Trivariate stereological unfolding}
\usage{
em.spheroids(P, F, maxIt, nCores = getOption("par.unfoldr", 2L))
}
\arguments{
\item{P}{coefficient array}

\item{F}{input histogram}

\item{maxIt}{maximum number of EM iterations}

\item{nCores}{number of cpu cores to be used}
}
\value{
trivariate histogram
}
\description{
Estimate the joint size-shape-orientation distribution of spheroids
}
\details{
Given an array of coefficients \code{P}, see \code{\link{coefficientMatrixSpheroids}} and an input histogram
\code{F} of measured planar characteristics of section profiles, the function estimates the spatial joint
size-shape-orientation distribution of the corresponding spheroids in 3D by a discretized version of the
\emph{Expectation Maximization} (EM) algorithm. A number of cpu cores can be set by the option '\code{par.unfoldr}'
for parallel computations. The function is also internally called by \code{\link{unfold}} in case of spheroids.
}
\examples{
## Comment: Trivariate unfolding of spheroid distribution

## set number of cpu cores (optional)
options(par.unfoldr=2L)

## Intensity: mean number of spheroids per unit volume
lam <- 1000

## simulation parameters
theta <- list("size"=list("meanlog"=-2.5,"sdlog"=0.5),
		      "shape"=list(0.5),"orientation"=list("kappa"=2))
## simualtion
set.seed(1234)

S <- simPoissonSystem(theta,lam,size="rlnorm",
		orientation="rbetaiso",box=list(c(0,5)),type="prolate",pl=1)

## unfolding
sp <- verticalSection(S,2.5)
ret <- unfold(sp,c(7,6,5),kap=1.25)
cat("Intensities: ", sum(ret$N_V)/25, "vs.",lam,"\\n")
}
\references{
Bene\eqn{\check{\textrm{s}}}, V. and Rataj, J. Stochastic Geometry: Selected Topics Kluwer Academic Publishers, Boston, 2004
}
\author{
M. Baaske
}
