% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sphere.R
\name{binning1d}
\alias{binning1d}
\title{Binning numeric values}
\usage{
binning1d(x, bin, na.rm = FALSE)
}
\arguments{
\item{x}{numeric values to be binned}

\item{bin}{non-decreasingly sorted breaks vector}

\item{na.rm}{logical, removing missing values (including NaN) in the argument \code{x}?}
}
\value{
Vector of count data
}
\description{
Vector of count data
}
\details{
This function provides basic binning (grouping) of numeric values into
classes defined by the breaks vector \code{bin}. The values are binned
according to bin[i[j]]\eqn{<}x[j]\eqn{\leq} bin[i[j]+1] for interval i=1,...,N-1
for \code{length(bin)=N} and value x[j].
If x[j] > bin[N] or x[j] < bin[1] then x[j] is not counted at all.
}
\examples{
x <- runif(100,0,1)
	bin <- seq(0,1,by=0.1)
	binning1d(x,bin)
}

