% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlotIP}
\alias{umxPlotIP}
\alias{plot.MxModelIP}
\title{Draw a graphical figure for a Independent Pathway model}
\usage{
umxPlotIP(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  showFixed = TRUE,
  format = c("current", "graphviz", "DiagrammeR"),
  SEstyle = FALSE,
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{The \code{\link[=umxIP]{umxIP()}} model to plot}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{showFixed}{Whether to graph paths that are fixed but != 0 (default = TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{SEstyle}{Report "b (se)" instead of "b [lower, upper]" (Default)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item optionally return the dot code
}
}
\description{
Options include digits (rounding), showing means or not, standardization, and which output format is desired.
}
\examples{
\dontrun{
require(umx)
data(GFF)
mzData = subset(GFF, zyg_2grp == "MZ")
dzData = subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff","fc","qol","hap","sat","AD") # These will be expanded into "gff_T1" "gff_T2" etc.
m1 =    umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
plot(model)
umxPlotIP(model, file = NA)
}
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxIP]{umxIP()}}
}

Other Plotting functions: 
\code{\link{ggAddR}()},
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{umx}},
\code{\link{umxPlot}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()}
}
\concept{Plotting functions}
