% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxFixAll}
\alias{umxFixAll}
\title{umxFixAll: Fix all free parameters}
\usage{
umxFixAll(model, name = "_fixed", run = FALSE, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} within which to fix free parameters}

\item{name}{optional new name for the model. if you begin with a _ it will be made a suffix}

\item{run}{whether to fix and re-run the model, or just return it (defaults to FALSE)}

\item{verbose}{whether to mention how many paths were fixed (default is FALSE)}
}
\value{
\itemize{
\item the fixed \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Fix all free parameters in a model using omxGetParameters()
}
\examples{
\dontrun{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("OneFactor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
m2 = umxFixAll(m1, run = TRUE, verbose = TRUE)
mxCompare(m1, m2)

}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: 
\code{\link{umxAlgebra}()},
\code{\link{umxJiggle}()},
\code{\link{umxRun}()},
\code{\link{umxThresholdMatrix}()},
\code{\link{umxUnexplainedCausalNexus}()},
\code{\link{umx}},
\code{\link{xmuLabel}()},
\code{\link{xmuValues}()}
}
\concept{Advanced Model Building Functions}
