% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_zero_inputs}
\alias{system_zero_inputs}
\title{Zero All Model Inputs}
\usage{
system_zero_inputs(cfg, bolus = TRUE, rates = TRUE)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{bolus}{Boolean value indicating weather bolus inputs should be set to zero}

\item{rates}{Boolean value indicating weather infusion rate inputs should be set to zero}
}
\value{
Ubiquity system object with the specified inputs set to zero
}
\description{
Multiple default inputs can be specified in the system file. At
the scripting level this function can be used to set all inputs to zero.
Then only the subsequently specified inputs will be applied.
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Clear only infusion rates
cfg = system_zero_inputs(cfg, bolus=TRUE, rates=FALSE)

# Clear all inputs:
cfg = system_zero_inputs(cfg)
}
}
\seealso{
\code{\link{system_set_rate}}, \code{\link{system_set_bolus}}
}
