% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrtest}
\alias{lrtest}
\title{Log-Rank Test of Survival Curve Difference}
\usage{
lrtest(
  data,
  stratum = "",
  treat = "treat",
  time = "time",
  time2 = "",
  event = "event",
  weight = "",
  weight_readj = FALSE,
  rho1 = 0,
  rho2 = 0
)
}
\arguments{
\item{data}{The input data frame or list of data frames that contains
the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{weight}: The weight for each observation.
}}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{weight_readj}{Whether the weight variable at each event time
will be readjusted to be proportional to the number at risk by
treatment group. Defaults to \code{FALSE}.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{uscore}: The numerator of the log-rank test statistic.
\item \code{vscore}: The variance of the log-rank score test statistic.
\item \code{logRankZ}: The Z-statistic value.
\item \code{logRankPValue}: The two-sided p-value.
\item \code{weight_readj}: Whether the weight variable will be readjusted.
\item \code{rho1}: The first parameter of the Fleming-Harrington weights.
\item \code{rho2}: The second parameter of the Fleming-Harrington weights.
}
}
\description{
Obtains the log-rank test using the Fleming-Harrington
family of weights.
}
\examples{

lrtest(rawdata[rawdata$iterationNumber == 1, ], 
       stratum = "stratum", treat = "treatmentGroup", 
       time = "timeUnderObservation", event = "event", 
       rho1 = 0.5, rho2 = 0)
             
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
