% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorMapSextant}
\alias{ColorMapSextant}
\title{Sextant Encoding of Ternary Composition}
\usage{
ColorMapSextant(P, center, values)
}
\arguments{
\item{P}{n by 3 matrix of ternary compositions {p1, p2, p3}_i for
i=1, ..., n.}

\item{center}{Ternary coordinates of the sextant meeting point.}

\item{values}{6 element character vector of rgb-codes.}
}
\value{
An n row data frame giving, for each row of the input P, the input
proportions (p1, p2, p3), sextant id (sextant) and the hex-rgb string of the
mixed colors (rgb).
}
\description{
Return the sextant scheme colors for a matrix of ternary compositions.
}
\examples{
P <- prop.table(matrix(runif(9), ncol = 3), 1)
tricolore:::ColorMapSextant(P, c(1/3, 1/3, 1/3),
                            c('#01A0C6', '#B8B3D8', '#F11D8C', '#FFB3B3',
                              '#FFFF00', '#B3DCC3'))
}
\keyword{internal}
