% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sackin.R
\name{sackin}
\alias{sackin}
\title{Fast function using C++ to calculate the sackin index of (im)balance.}
\usage{
sackin(phy, normalization = "none")
}
\arguments{
\item{phy}{phylogeny or ltable}

\item{normalization}{normalization, either 'none' (default), "yule" or "pda".}
}
\value{
Sackin index
}
\description{
The Sackin index is calculated as the sum of ancestors for each
of the tips. Higher values indicate higher imbalance. Two normalizations
are available, where a correction is made for tree size, under either a
Yule expectation, or a pda expectation.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
brts <- branching_times(simulated_tree)
if (requireNamespace("nodeSub")) {
  balanced_tree <- nodeSub::create_balanced_tree(brts)
  unbalanced_tree <- nodeSub::create_unbalanced_tree(brts)
  sackin(balanced_tree)
  sackin(unbalanced_tree) # should be much higher
}
}
\references{
M. J. Sackin (1972). "Good" and "Bad" Phenograms.
Systematic Biology. 21:225-226.
}
