% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{group_by.treedata}
\alias{group_by.treedata}
\alias{ungroup.grouped_treedata}
\title{Function for grouping an object of class \code{treedata}}
\usage{
\method{group_by}{treedata}(.data, ..., .add = FALSE)

\method{ungroup}{grouped_treedata}(x, ...)
}
\arguments{
\item{.data}{An object of class \code{treedata}}

\item{...}{The name of the grouping factor.}

\item{.add}{By default, when .add = FALSE, group_by will override existing groups.
To instead add to the existing groups, use .add = TRUE}

\item{x}{An object of class \code{treedata}}
}
\value{
An object of class \code{grouped_treedata}.
}
\description{
This function can be used to group a treedata object by some factor.
}
\details{
Groups the data frame and phylogeny by one of the factors in the data table.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat)
tdGrouped <- group_by(td, ecomorph)
summarize(tdGrouped, ntips = length(phy$tip.label),
   totalBL = sum(phy$edge.length), meanSVL = mean(SVL), sdSVL = sd(SVL))
}
\seealso{
\code{\link{summarize}}
}
