% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/straightness.R
\name{TrajEmax}
\alias{TrajEmax}
\title{Trajectory straightness index, E-max}
\usage{
TrajEmax(trj, eMaxB = FALSE, compass.direction = NULL)
}
\arguments{
\item{trj}{Trajectory to be analysed.}

\item{eMaxB}{If TRUE, calculates and returns Emax-b, otherwise returns
Emax-a.}

\item{compass.direction}{if not \code{NULL}, turning angles are calculated
for a directed walk, assuming the specified compass direction (in radians).
Otherwise, a random walk is assumed.}
}
\value{
Emax (-a or -b) for \code{trj}.
}
\description{
Emax, the maximum expected displacement, is a single-valued measure of
straightness defined by (Cheung, Zhang, Stricker, & Srinivasan, 2007). Emax-a
is a dimensionless, scale-independent measure of the maximum possible
expected displacement. Emax-b is \code{Emax-a * mean step length}, and gives
the maximum possible expected displacement in spatial units. Values closer to
0 are more sinuous, while larger values (approaching infinity) are
straighter.
}
\references{
Cheung, A., Zhang, S., Stricker, C., & Srinivasan, M. V. (2007).
  Animal navigation: the difficulty of moving in a straight line. Biological
  Cybernetics, 97(1), 47-61. doi:10.1007/s00422-007-0158-0
}
