% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/methods-TxpModel.R,
%   R/methods-TxpModelList.R, R/txpCalculateScores.R
\name{txpCalculateScores}
\alias{txpCalculateScores}
\alias{txpCalculateScores,TxpModel,data.frame-method}
\alias{txpCalculateScores,TxpModelList,data.frame-method}
\alias{txpCalculateScores,list,data.frame-method}
\title{Calculate ToxPi Scores for the given model and input data}
\usage{
txpCalculateScores(model, input, ...)

\S4method{txpCalculateScores}{TxpModel,data.frame}(
  model,
  input,
  id.var = NULL,
  rank.ties.method = c("average", "first", "last", "random", "max", "min")
)

\S4method{txpCalculateScores}{TxpModelList,data.frame}(
  model,
  input,
  id.var = NULL,
  rank.ties.method = c("average", "first", "last", "random", "max", "min")
)

\S4method{txpCalculateScores}{list,data.frame}(
  model,
  input,
  id.var = NULL,
  rank.ties.method = c("average", "first", "last", "random", "max", "min")
)
}
\arguments{
\item{model}{\link{TxpModel} object or \link{TxpModelList} object}

\item{input}{data.frame object containing the model input data}

\item{...}{Included for extendability; not currently used}

\item{id.var}{Character scalar, column in 'input' to store in}

\item{rank.ties.method}{Character scalar, passed to \link[base:rank]{base::rank}}
}
\value{
\link{TxpResult} or \link{TxpResultList} object
}
\description{
Calculate ToxPi Scores for the given model and input data
}
\details{
\code{txpCalculateScores} is implemented as an S4 generic function with methods
for \link{TxpModel} and \link{TxpModelList}.

Ranks are calculated such that the highest ToxPi score has a rank of 1.
}
\examples{
## Load example dataset & model; see ?TxpModel for building model objects
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")

## Calculate scores for single model; returns TxpResult object
res <- txpCalculateScores(model = txp_example_model, 
                          input = txp_example_input, 
                          id.var = "name")

## Calculate scores for list of models; returns TxpResultList object
txpCalculateScores(model = TxpModelList(m1 = txp_example_model, 
                                        m2 = txp_example_model), 
                   input = txp_example_input, 
                   id.var = "name")
resLst <- txpCalculateScores(model = list(m1 = txp_example_model, 
                                          m2 = txp_example_model), 
                             input = txp_example_input, 
                             id.var = "name")

}
\seealso{
\link{TxpModel}, \link{TxpResult}
}
