% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-density.r
\name{display_dist}
\alias{display_dist}
\alias{animate_dist}
\title{1d distribution tour path animation.}
\usage{
display_dist(method = "density", center = TRUE, half_range = NULL,
  rug = FALSE, ...)

animate_dist(data, tour_path = grand_tour(1), ...)
}
\arguments{
\item{method}{display method, histogram or density plot}

\item{center}{should 1d projection be centered to have mean zero (default: TRUE).
This pins the centre of distribution to the same place, and makes it
easier to focus on the shape of the distribution.}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{rug}{draw rug plot showing position of actual data points?}

\item{...}{other arguments passed on to \code{\link{animate}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
Animate a 1d tour path with a density plot or histogram.
}
\examples{
animate_dist(flea[, 1:6])

# When the distribution is not centred, it tends to wander around in a
# distracting manner
animate_dist(flea[, 1:6], center = FALSE)

# Alternatively, you can display the distribution with a histogram
animate_dist(flea[, 1:6], method = "hist")
}
\seealso{
\code{\link{animate}} for options that apply to all animations
}
\keyword{hplot}
