% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_ts_find_keys}
\alias{db_ts_find_keys}
\title{Get All keys that follow a pattern}
\usage{
db_ts_find_keys(con, pattern, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{pattern}{\strong{character} that represents a regular expression to find keys}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Get All keys that follow a pattern
}
\examples{

\dontrun{
db_ts_store(con = connection, zrh_airport, schema = "schema")

# get all keys that start with "ch"
db_ts_find_keys(
  con = connection,
  "^ch",
  schema = "schema")
}
}
\seealso{
Other access levels functions: 
\code{\link{change_access_level}},
\code{\link{db_access_level_create}()},
\code{\link{db_access_level_delete}()},
\code{\link{db_access_level_list}()},
\code{\link{db_access_level_set_default}()}
}
\concept{access levels functions}
