% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_time_series.R
\name{db_ts_delete_latest_version}
\alias{db_ts_delete_latest_version}
\title{Delete the Latest Vintage of a Time Series}
\usage{
db_ts_delete_latest_version(con, ts_keys, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Vintages of time series should not be deleted as they are versions and
represent a former status of a time series that may not be stored elsewhere,
even not with their original provider. To benchmark forecasts it is essential
to keep the versions to evaluate real time performance of forecasts. However,
when operating at current edge of a time series, i.e., its last update, mistakes
may happen. Hence timeseriesdb allows to update / delete the last iteration.
Do not loop recursively through iterations to delete an entire time series.
There are admin level functions for that.
}
\examples{

\dontrun{

# Store different versions of the time series data
ch.kof.barometer <- kof_ts["baro_2019m11"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2019-12-01",
  schema = "schema"
)

ch.kof.barometer <- kof_ts["baro_2019m12"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2020-01-01",
  schema = "schema"
)

db_ts_delete_latest_version(
  con = connection,
  ts_keys = "ch.kof.barometer",
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
