% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{db_collection_read_metadata}
\alias{db_collection_read_metadata}
\title{Read Metadata for a Collection}
\usage{
db_collection_read_metadata(
  con,
  collection_name,
  collection_owner,
  valid_on = NULL,
  locale = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{collection_name}{character name of the collection.}

\item{collection_owner}{character name of the collection owner.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{locale}{\strong{character} indicating the language of the meta information to be store. We recommend to use ISO country codes to represent languages. Defaults to NULL. When local is set to NULL, metadata are stored without localization. Note that, when localizing meta information by assigning a language, multiple meta information objects can be stored for a single time series.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
list of all available meta descriptions for a particular collection and language.
}
\description{
Read Metadata for a Collection
}
\seealso{
Other metadata functions: 
\code{\link{db_dataset_read_metadata}()},
\code{\link{db_meta_get_latest_validity}()},
\code{\link{db_metadata_read}()},
\code{\link{db_metadata_store}()}
}
\concept{metadata functions}
