% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na-Spat.R
\name{replace_na.Spat}
\alias{replace_na.Spat}
\alias{replace_na.SpatRaster}
\alias{replace_na.SpatVector}
\title{Replace NAs with specified values}
\usage{
\method{replace_na}{SpatRaster}(data, replace = list(), ...)

\method{replace_na}{SpatVector}(data, replace, ...)
}
\arguments{
\item{data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{replace}{list of values, with one value for each layer/attribute that
has \code{NA} values to be replaced.}

\item{...}{Ignored}
}
\value{
A Spat* object  of the same class than \code{data}. Geometries and
spatial attributes are preserved.
}
\description{
Replace \code{NAs} on layers/attributes with specified values
}
\section{terra equivalent}{


Use \verb{r[is.na(r)] <- <replacement>}
}

\examples{

library(terra)

f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

r \%>\% plot()

r \%>\%
  replace_na(list(tavg_04 = 6, tavg_06 = 20)) \%>\%
  plot()

}
\seealso{
\code{\link[tidyr:replace_na]{tidyr::replace_na()}}

Other tidyr.methods: 
\code{\link{drop_na.SpatVector}()}
}
\concept{tidyr.methods}
