% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_cascade.R
\name{vl_cascade}
\alias{vl_cascade}
\title{Analyse the Viral Load Cascade Indicators}
\usage{
vl_cascade(
  data,
  ref = NULL,
  states = NULL,
  facilities = NULL,
  status = "default",
  n = 1000,
  use_six_months = TRUE,
  remove_duplicates = FALSE,
  .level = "state",
  .names = NULL
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr().}

\item{ref}{Date provided in ISO8601 format ("yyyy-mm-dd"). Used to
determine clients who are eligible for viral load and should have a
documented result. The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{n}{the value below which viral load result is adjudged to be suppressed.}

\item{use_six_months}{\code{TRUE} of \code{FALSE}. To determine if six months eligibility should be used for pediatrics and adolescents repeat viral load or the standard annual repeat.}

\item{remove_duplicates}{Boolean argument. It specifies if duplicate patient entries in the facilities should be removed or kept}

\item{.level}{the level at which the aggregate summary should be performed. The options are "ip", "country", "state", "lga" and "facility".}

\item{.names}{if specified, these will be used for naming of the viral load indicators instead of the default.}
}
\value{
summary of viral load cascade
}
\description{
Generate aggregate summary of viral load indicators based on a referenced date. The indicators include \code{eligible}, \verb{documented results},
\verb{virally suppressed}, \verb{viral load coverage}, and \verb{viral load suppression rate}.
}
\examples{
vl_cascade(ndr_example, ref = "2021-12-31", .level = "state")

# Determine the viral load cascade for a state at the end of September 2021
vl_cascade(ndr_example,
  ref = "2021-10-31",
  states = "Arewa"
)

}
