% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rita_sample.R
\name{rita_sample}
\alias{rita_sample}
\title{Generate List of RTRI-Positive Clients whose Viral Load Samples Have Been Collected}
\usage{
rita_sample(data, from = NULL, to = NULL, states = NULL, facilities = NULL)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}
}
\value{
Line-list of clients with recent infection and a viral load samples collected
}
\description{
Generate List of RTRI-Positive Clients whose Viral Load Samples Have Been Collected
}
\examples{
## Get HTS_POS clients who had recency testing and viral load sample collected
sample_collected <- rita_sample(recency_example)

## Samples collected in 'Ayetoro', and 'Arewa' states

rita_sample(recency_example, states = c("Arewa", "Ayetoro"))

}
