% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-generate_layout.R
\name{get_layout.lavaan}
\alias{get_layout.lavaan}
\alias{get_layout}
\alias{get_layout.default}
\title{Generate graph layout}
\usage{
\method{get_layout}{lavaan}(x, ..., layout_algorithm = "layout_as_tree")

get_layout(x, ...)

\method{get_layout}{default}(x, ..., rows = NULL)
}
\arguments{
\item{x}{An object for which a method exists; currently, methods exist for
\code{character}, \code{lavaan}, and \code{mplus.model} objects.}

\item{...}{Character arguments corresponding to layout elements. Use node
names, empty strings (""), or NA values.}

\item{layout_algorithm}{Optional argument for fit model objects. Character
string, indicating which \code{igraph}
layout algorithm to apply to position the nodes. Defaults to
\code{"layout_as_tree"}; see details for more options.}

\item{rows}{Numeric, indicating the number of rows of the graph.}
}
\value{
Object of class 'tidy_layout'
}
\description{
Generate a tidy_layout for a SEM graph.
}
\details{
There are three ways to generate a layout:
\enumerate{
  \item Specify the layout in the call to \code{get_layout()} by providing
  node names and the number of
  rows to create a layout matrix. Empty strings (\code{""})
  or \code{NA} can be used for empty cells. See Example 1.
  \item Call \code{get_layout()} on a model object or \code{tidy_results}
  object. It will use the function
  \code{\link[igraph]{layout_as_tree}}, or any other layout function
  from the \code{igraph} package, to generate a rudimentary layout. See
  Example 2.
  \item Instead of using \code{get_layout()}, just use a \code{matrix} or
  \code{data.frame} with your layout. For example, specify the layout in a
  spreadsheet program, and load it into R (see Example 3). Or, copy the
  layout to the clipboard from your spreadsheet program, and load it from the
  clipboard (see Example 4)
}
The layout algorithms imported from \code{igraph} are:
\code{c("layout_as_star",
"layout_as_tree", "layout_in_circle", "layout_nicely",
"layout_on_grid", "layout_randomly", "layout_with_dh", "layout_with_fr",
"layout_with_gem",
"layout_with_graphopt", "layout_with_kk", "layout_with_lgl",
"layout_with_mds")}. These can be used by specifying the optional argument
\code{layout_algorithm = ""}.
}
\examples{
# Example 1
get_layout("c", NA,  "d",
           NA,  "e", NA, rows = 2)

# Example 2
library(lavaan)
fit <- cfa(' visual  =~ x1 + x2 + x3 ',
           data = HolzingerSwineford1939[1:50, ])
get_layout(fit)

\dontrun{
# Example 3
# Here, we first write the layout to .csv, but you could create it in a
# spreadsheet program, and save the spreadsheet to .csv:
write.csv(matrix(c("c", "",  "d", "",  "e", ""), nrow = 2, byrow = TRUE),
          file = file.path(tempdir(), "example3.csv"), row.names = FALSE)
# Now, we load the .csv:
read.csv(file.path(tempdir(), "example3.csv"))

# Example 4
# For this example, make your layout in a spreadsheet program, select it, and
# copy to clipboard. Reading from the clipboard works differently in Windows
# and Mac. For this example, I used Microsoft Excel.
# On Windows, run:
read.table("clipboard", sep = "\t")
# On Mac, run:
read.table(pipe("pbpaste"), sep="\t")
}
}
\keyword{tidy_graph}
