% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,feis-method}
\alias{extract,feis-method}
\alias{extract.feis}
\title{\code{\link{extract}} method for \code{feis} objects}
\usage{
\S4method{extract}{feis}(
  model,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  include.rmse = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.adjrs}{Report adjusted R^2 in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{include.rmse}{Report the root mean square error (RMSE; = residual
standard deviation) in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{feis} objects created by the
\code{\link[feisr]{feis}} function in the \pkg{feisr} package.
}
\author{
Tobias Rüttenauer, Philip Leifeld
}
