% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_vitals.R
\name{template_vitals}
\alias{template_vitals}
\title{Template: Patient Profile Vitals Plot}
\usage{
template_vitals(
  dataname = "ANL",
  paramcd = "PARAMCD",
  paramcd_levels = c("SYSBP", "DIABP", "PUL", "RESP", "OXYSAT", "WGHT", "TEMP"),
  xaxis = "ADY",
  aval = lifecycle::deprecated(),
  aval_var = "AVAL",
  patient_id,
  font_size = 12L,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{paramcd}{(\code{character})\cr name of the parameter code variable.}

\item{paramcd_levels}{(\code{character})\cr vector of all levels of \code{paramcd}.}

\item{xaxis}{(\code{character})\cr name of the time variable to put on the x-axis.}

\item{aval}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{aval_var} argument instead.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{patient_id}{(\code{character})\cr patient ID.}

\item{font_size}{(\code{numeric})\cr font size value.}

\item{ggplot2_args}{optional, (\code{ggplot2_args})\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a patient profile vitals \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot using ADaM datasets.
}
\seealso{
\code{\link[=tm_g_pp_vitals]{tm_g_pp_vitals()}}
}
\keyword{internal}
