% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon.R
\name{taxon}
\alias{taxon}
\title{Taxon class}
\usage{
taxon(name, rank = NULL, id = NULL, authority = NULL)
}
\arguments{
\item{name}{a TaxonName object \code{\link[=taxon_name]{taxon_name()}} or character string. if character
passed in, we'll coerce to a TaxonName object internally, required}

\item{rank}{a TaxonRank object \code{\link[=taxon_rank]{taxon_rank()}} or character string. if character
passed in, we'll coerce to a TaxonRank object internally, required}

\item{id}{a TaxonId object \code{\link[=taxon_id]{taxon_id()}}, numeric/integer, or character string.
if numeric/integer/character passed in, we'll coerce to a TaxonId object
internally, required}

\item{authority}{(character) a character string, optional}
}
\value{
An \code{R6Class} object of class \code{Taxon}
}
\description{
A class used to define a single taxon. Most other classes in the taxa package
include one or more objects of this class.
}
\details{
Note that there is a special use case of this function - you can
pass \code{NULL} as the first parameter to get an empty \code{taxon} object. It makes
sense to retain the original behavior where nothing passed in to the first
parameter leads to an error, and thus creating a \code{NULL} taxon is done very
explicitly.
}
\examples{
(x <- taxon(
  name = taxon_name("Poa annua"),
  rank = taxon_rank("species"),
  id = taxon_id(93036)
))
x$name
x$rank
x$id

# a null taxon object
taxon(NULL)
## with all NULL objects from the other classes
taxon(
  name = taxon_name(NULL),
  rank = taxon_rank(NULL),
  id = taxon_id(NULL)
)
}
\seealso{
Other classes: 
\code{\link{hierarchies}()},
\code{\link{hierarchy}()},
\code{\link{taxa}()},
\code{\link{taxmap}()},
\code{\link{taxon_database}()},
\code{\link{taxon_id}()},
\code{\link{taxon_name}()},
\code{\link{taxon_rank}()},
\code{\link{taxonomy}()}
}
\concept{classes}
