% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bighornSheep.R
\docType{data}
\name{bighornSheep}
\alias{bighornSheep}
\title{Bighorn Sheep}
\format{
The data frame has 8000 rows (a geographic sample unit) and 15 variables:
\describe{
  \item{sampleUnit}{ Sample unit ID, 150m circles randomly overlayed across the study area}
  \item{count}{Count of use by bighorn sheep.}
  \item{slope}{Average slope (degrees) within the sampling unit}
  \item{elev}{Average elevation (m) within the sampling unit}
  \item{distBurn}{Sampling unit center to nearest (m) burned habitat edge calculated after fire event}
  \item{distRoad}{Sampling unit center to nearest (m) road}
  \item{distEscp}{Sampling unit center to nearest (m) escape terrain (slope > 27 degrees)}
  \item{distWater}{Sampling unit center to nearest (m) perennial water source}
\item{aspect}{Dominant cardinal direction within each sampling unit}
\item{fire}{ 1 = after fire, 0 = before fire}
\item{season}{ Season, summer or winter}
 }
}
\usage{
data(bighornSheep)
}
\description{
Bighorn Sheep data
}
\details{
Twelve female bighorn sheep are radio collared and tracked. Location of use of points is recorded before and after a forest fire.
}
\examples{
data('bighornSheep', package='syllogi')
str(bighornSheep)
}
\references{
Clapp, J.G., Beck, J.L. Short-Term Impacts of Fire-Mediated Habitat Alterations on an Isolated Bighorn Sheep Population. fire ecol 12, 80–98 (2016). https://doi.org/10.4996/fireecology.1203080
}
\keyword{data}
