% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_data_format.R
\name{set_data_format}
\alias{set_data_format}
\title{Data Formatting}
\usage{
set_data_format(
  raw_x,
  raw_y,
  raw_t,
  raw_id,
  origin,
  period,
  tz,
  proj,
  format,
  ...
)
}
\arguments{
\item{raw_x}{A numeric vector representing the x coordinates of individual(s).}

\item{raw_y}{A numeric vector representing the y coordinates of individual(s).}

\item{raw_t}{A numeric vector that can be coerced to date-time objects by as
datetime representing the times (or frames) at which each location
was recorded.}

\item{raw_id}{A vector representing the identity of each coordinate
recording.}

\item{origin}{Something that can be coerced to a date-time object by as_
datetime representing the start date and time of the observations when t is
a numeric vector.}

\item{period}{A character vector in a shorthand format (e.g. "1 second")
or ISO 8601 specification. This is used when t is a numeric vector to
represent time unit of the observations.}

\item{tz}{A time zone name. See OlsonNames.}

\item{proj}{A character string or a \code{sp::CRS} object representing
the projection of the coordinates. Leave empty if the coordinates are
not projected (e.g., output of video tracking). "+proj=longlat" is suitable
for the output of most GPS trackers.}

\item{format}{A character string indicating the formatting of 't'.
See strptime for how to specify this parameter.}

\item{...}{Additional vectors representing categories that the data
should be split by. If none, only the date will be used as a unit of data
separation.}
}
\value{
A track dataframe table, which is a colloquial term for an
 object of class track.
}
\description{
This function is a wrapper for the  \code{track} function of the \code{trackdf} package.
}
\examples{
\donttest{
raw_data <- data.frame(
 frame = rep(1:25, 3),
 x = rnorm(75),
 y = rnorm(75),
 id = c(rep(1, 25), rep(2, 25), rep(3, 25))
 )

data <- set_data_format(
 raw_x = raw_data$x,
 raw_y = raw_data$y,
 raw_t = raw_data$frame,
 raw_id = raw_data$id,
 period = 1,
 origin = Sys.time(),
 tz = "Africa/Windhoek"
 )
}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
