% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHazardInfluenceCurve.R
\name{getHazardInfluenceCurve}
\alias{getHazardInfluenceCurve}
\title{Extract Influence Curve for Estimated Hazard Functions}
\usage{
getHazardInfluenceCurve(dataList, dat, allJ, ofInterestJ, nJ, uniqtrt, t0,
  verbose, ...)
}
\arguments{
\item{dataList}{A list of \code{data.frame} objects. See \code{?makeDataList}
for more information.}

\item{dat}{A \code{data.frame} in short form. See \code{?makeDataList} for
more information.}

\item{allJ}{Numeric vector indicating the labels of all causes of failure.}

\item{ofInterestJ}{Numeric vector indicating \code{ftypeOfInterest} that was
passed to \code{hazard_tmle}.}

\item{nJ}{The number of unique failure types.}

\item{uniqtrt}{The values of \code{trtOfInterest} passed to \code{mean_tmle}.}

\item{t0}{The timepoint at which \code{survtmle} was called to evaluate.}

\item{verbose}{A boolean indicating whether the function should print
messages to indicate progress.}

\item{...}{Other arguments. Not currently used.}
}
\value{
An object of class \code{data.frame} with columns \code{D.jX.zZ}
        added for each value of X in \code{ofInterestJ} and each value of Z
        in \code{uniqtrt}. These are the sum over all timepoints of the
        estimated efficient influence function evaluated at that observation.
}
\description{
This function computes the hazard-based efficient influence curve at the
final estimate of the fluctuated cause-specific hazard functions and
evaluates it on the observed data. The influence-function is computed on the
long-format data but is subsequently summed over all timepoints for each
observation and the function returns a new short form data set with columns
added corresponding to the sum over all timepoints of the estimated
efficient influence function evaluated at that observation.
}
