% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli_ARL.R
\name{bernoulli_RL_cdf}
\alias{bernoulli_RL_cdf}
\title{Cumulative distribution function (cdf) of Run Length for Bernoulli CUSUM}
\usage{
bernoulli_RL_cdf(h, x, n_grid, glmmod, theta, theta_true, p0, p1,
  smooth_prob = FALSE, exact = TRUE)
}
\arguments{
\item{h}{Control limit for the Bernoulli CUSUM}

\item{x}{Quantile at which to evaluate the cdf.}

\item{n_grid}{Number of state spaces used to discretize the outcome space (when \code{method = "MC"})
or number of grid points used for trapezoidal integration (when \code{method = "SPRT"}).
Increasing this number improves accuracy, but can also significantly increase computation time.}

\item{glmmod}{Generalized linear regression model used for risk-adjustment as produced by
the function \code{\link[stats:glm]{glm()}}. Suggested: \cr
\code{glm(as.formula("(survtime <= followup) & (censorid == 1) ~ covariates"), data = data)}. \cr
Alternatively, a list containing the following elements:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
}}

\item{theta}{The \eqn{\theta}{\theta} value used to specify the odds ratio
\eqn{e^\theta}{e^\theta} under the alternative hypothesis.
If \eqn{\theta >= 0}{\theta >= 0}, the average run length for the upper one-sided
Bernoulli CUSUM will be determined. If \eqn{\theta < 0}{\theta < 0},
the average run length for the lower one-sided CUSUM will be determined.
Note that \deqn{p_1 = \frac{p_0 e^\theta}{1-p_0 +p_0 e^\theta}.}{p1 = (p0 * e^\theta)/(1-p0+p0 * e^\theta).}}

\item{theta_true}{The true log odds ratio \eqn{\theta}{\theta}, describing the
true increase in failure rate from the null-hypothesis. Default = log(1), indicating
no increase in failure rate.}

\item{p0}{The baseline failure probability at \code{entrytime + followup} for individuals.}

\item{p1}{The alternative hypothesis failure probability at \code{entrytime + followup} for individuals.}

\item{smooth_prob}{Should the probability distribution of failure under the null distribution be smoothed?
Useful for small samples. Can only be TRUE when \code{glmmod} is supplied. Default = FALSE.}

\item{exact}{Should the cdf be determined exactly (TRUE), or approximately
(FALSE)? The approximation works well for large \code{x}, and can cut computation
time significantly. Default = TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{Fr_0}: A numeric value indicating the probability of the run
length being smaller than \code{x}.
\item \code{Fr}: A \code{data.frame} containing the cumulative distribution function of the run length
depending on the state in which the process starts (E_0, E_1, ..., E_{n_grid-1})
\describe{
\item{\code{start_val}:}{Starting value of the CUSUM, corresponding to the
discretized state spaces E_{i};}
\item{\code{P(K <= x)}:}{Value of the cdf at \code{x} for the CUSUM with
initial value \code{start_val};}
}
\item \code{R}: A transition probability \code{matrix} containing the transition
probabilities between states \eqn{E_0, \ldots, E_{t-1}}{E_0, ..., E_{n_grid-1}}.
\eqn{R_{i,j}}{R_{i,j}} is the transition probability from state i to state j.
} The value of \code{ARL_0} will be printed to the console.
}
\description{
Calculate the cdf of the Run Length of the Bernoulli CUSUM,
starting from initial value between 0 and \code{h}, using Markov Chain methodology.
}
\details{
Let \eqn{K}{K} denote the run length of the Bernoulli CUSUM with control limit \code{h}, then
this function can be used to evaluate \eqn{P(K \leq x)}{P(K <= x)}.

The formula on page 543 of Brook & Evans (1972)
is used if \code{exact = TRUE}. When \code{exact = FALSE}, formula (3.9) on
page 545 is used instead, approximating the transition matrix using its
Jordan canonical form. This can save computation time considerably, but is
not appropriate for small values of \code{x}.
}
\examples{
#Determine a risk-adjustment model using a generalized linear model.
#Outcome (failure within 100 days) is regressed on the available covariates:
glmmodber <- glm((survtime <= 100) & (censorid == 1)~ age + sex + BMI,
                  data = surgerydat, family = binomial(link = "logit"))
#Determine probability of run length being less than 600
prob600 <- bernoulli_RL_cdf(h = 2.5, x = 600, n_grid = 200, glmmod = glmmodber, theta = log(2))
}
\references{
Brook, D., & Evans, D. A. (1972). An Approach to the Probability
Distribution of Cusum Run Length. Biometrika, 59(3), 539–549.
\doi{10.2307/2334805}

Steiner, S. H., Cook, R. J., Farewell, V. T., & Treasure, T. (2000).
Monitoring surgical performance using risk-adjusted cumulative sum charts.
Biostatistics, 1(4), 441–452. \doi{10.1093/biostatistics/1.4.441}
}
