% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_view2qualtrics.R
\name{strview2qualtrics}
\alias{strview2qualtrics}
\alias{strview2rate}
\alias{strview2pwc}
\title{strview2qualtrics}
\usage{
strview2rate(df, header, questions, choices, file)

strview2pwc(df, k, header, questions, file)
}
\arguments{
\item{df}{StreetscapeDataFrame}

\item{header}{character, indicating the task for a question.
For example, "Please review the following picture:"}

\item{questions}{vector, a list of questions (see details)}

\item{choices}{list, a list of choices (see details)
(this is only for strview2rate)}

\item{file}{character, indicating the directory and file name
(without extension) for saving the Qualtrics survey file}

\item{k}{numeric, indicating how many street views each street view will
be paired with for pair-wised comparison (this is only for strview2pwc)}
}
\value{
character if argument 'file' is not specified

character if argument 'file' is not specified
}
\description{
strview2rate: pack street views as a Qualtrics survey file that
can be imported to Qualtrics platform

strview2pwc: pack street views as a Qualtrics survey file for
pair-wised comparison
}
\details{
strview2qualtrics

For strview2rate(), the lengths of questions and choices must match.
For example, when questions = c('1. To what existence you can feel pleasant
if you were in this environment', '2. To what existence you can feel safe
if you were in this environment'), choices could be list(c('Unpleasant',
'Less pleasant', 'More pleasant', 'Pleasant'), c('Unsafe', 'Less safe', 'Safer',
'Safe'))
For strview2pwc, the choices are always c('left', 'right') for the coparison
purposes.
}
\examples{
data('scdataframe')
header <- "Please review the following picture(s):"
questions <- c('1. To what extent you feel pleasant if you were in this environment',
              '2. To what extent you feel safe if you were in this environment')
choices <- list(c('Unpleasant','Less pleasant', 'Pleasant', 'More pleasant'),
                c('Unsafe', 'Less safe','Safe', 'Safer'))
txt <- streetscape::strview2rate(scdataframe, header, questions, choices)

data('scdataframe')
header <- "Please review the following picture(s):"
questions <- 'which one is more beautiful?'
txt <- streetscape::strview2pwc(scdataframe, k=1, header, questions)

}
