/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch;

import moa.classifiers.lazy.neighboursearch.NearestNeighbourSearch;
import weka.core.Instance;
import weka.core.Instances;

public class LinearNNSearch
extends NearestNeighbourSearch {
    private static final long serialVersionUID = 1915484723703917241L;
    protected double[] m_Distances;
    protected boolean m_SkipIdentical = false;

    public LinearNNSearch() {
    }

    public LinearNNSearch(Instances insts) {
        super(insts);
        this.m_DistanceFunction.setInstances(insts);
    }

    public String globalInfo() {
        return "Class implementing the brute force search algorithm for nearest neighbour search.";
    }

    public String skipIdenticalTipText() {
        return "Whether to skip identical instances (with distance 0 to the target)";
    }

    public void setSkipIdentical(boolean skip) {
        this.m_SkipIdentical = skip;
    }

    public boolean getSkipIdentical() {
        return this.m_SkipIdentical;
    }

    public Instance nearestNeighbour(Instance target) throws Exception {
        return this.kNearestNeighbours(target, 1).instance(0);
    }

    public Instances kNearestNeighbours(Instance target, int kNN2) throws Exception {
        NearestNeighbourSearch.MyHeapElement h;
        boolean print = false;
        NearestNeighbourSearch.MyHeap heap = new NearestNeighbourSearch.MyHeap(this, kNN2);
        int firstkNN = 0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double distance;
            if (target == this.m_Instances.instance(i)) continue;
            if (firstkNN < kNN2) {
                if (print) {
                    System.out.println("K(a): " + (heap.size() + heap.noOfKthNearest()));
                }
                if ((distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(i), Double.POSITIVE_INFINITY)) == 0.0 && this.m_SkipIdentical) {
                    if (i < this.m_Instances.numInstances() - 1) continue;
                    heap.put(i, distance);
                }
                heap.put(i, distance);
                ++firstkNN;
                continue;
            }
            NearestNeighbourSearch.MyHeapElement temp = heap.peek();
            if (print) {
                System.out.println("K(b): " + (heap.size() + heap.noOfKthNearest()));
            }
            if ((distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(i), temp.distance)) == 0.0 && this.m_SkipIdentical) continue;
            if (distance < temp.distance) {
                heap.putBySubstitute(i, distance);
                continue;
            }
            if (distance != temp.distance) continue;
            heap.putKthNearest(i, distance);
        }
        Instances neighbours = new Instances(this.m_Instances, heap.size() + heap.noOfKthNearest());
        this.m_Distances = new double[heap.size() + heap.noOfKthNearest()];
        int[] indices = new int[heap.size() + heap.noOfKthNearest()];
        int i = 1;
        while (heap.noOfKthNearest() > 0) {
            h = heap.getKthNearest();
            indices[indices.length - i] = h.index;
            this.m_Distances[indices.length - i] = h.distance;
            ++i;
        }
        while (heap.size() > 0) {
            h = heap.get();
            indices[indices.length - i] = h.index;
            this.m_Distances[indices.length - i] = h.distance;
            ++i;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (int k = 0; k < indices.length; ++k) {
            neighbours.add(this.m_Instances.instance(indices[k]));
        }
        return neighbours;
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void setInstances(Instances insts) throws Exception {
        this.m_Instances = insts;
        this.m_DistanceFunction.setInstances(insts);
    }

    public void update(Instance ins) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(ins);
    }

    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

