% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_sample_char.R
\docType{methods}
\name{choice_c,report_sample_char-method}
\alias{choice_c,report_sample_char-method}
\alias{choice_c.report_sample_char}
\title{command line interface for report_sample_char class}
\usage{
\S4method{choice_c}{report_sample_char}(object, dc, taxa, stage, par,
  horodatedebut, horodatefin, silent = FALSE)
}
\arguments{
\item{object}{An object of class \link{report_sample_char-class}}

\item{dc}{A numeric or integer, the code of the dc, coerced to integer,see \link{choice_c,ref_dc-method}}

\item{taxa}{Either a species name in latin or the SANDRE code for species (ie 2038=Anguilla anguilla),
these should match the ref.tr_taxon_tax referential table in the stacomi database, see \link{choice_c,ref_taxa-method}}

\item{stage}{A stage code matching the ref.tr_stadedeveloppement_std table in the stacomi database, see \link{choice_c,ref_stage-method}}

\item{par}{A parameter matching th ref.tg_parametre_par table in the stacomi database, see \link{choice_c,ref_par-method}}

\item{horodatedebut}{The starting date as a character, formats like \code{\%Y-\%m-\%d} or \code{\%d-\%m-\%Y} can be used as input}

\item{horodatefin}{The finishing date of the report, for this class this will be used to calculate the number of daily steps.}

\item{silent}{Boolean, if TRUE, information messages are not displayed}
}
\value{
An object of class \link{report_mig-class}
The choice_c method fills in the data slot for classes \link{ref_dc-class}, \link{ref_taxa-class}, \link{ref_stage-class}, \link{ref_par-class} and two slots of \link{ref_horodate-class} and then 
uses the choice_c methods of these object to select the data.
}
\description{
command line interface for report_sample_char class
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
