% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_env.R
\docType{class}
\name{report_env-class}
\alias{report_env-class}
\alias{report_env}
\title{class report_env simple output of one or several environmental
conditions...}
\description{
Annual overview of environmental conditions. This class enables to draw some plot, but will mostly used to build
joined graphs crossing the information from \link{report_mig_mult-class} and \link{report_mig_env-class}
}
\section{Slots}{

\describe{
\item{\code{horodatedebut}}{\link{ref_horodate-class}}

\item{\code{horodatefin}}{\link{ref_horodate-class}}

\item{\code{stationMesure}}{\link{ref_env-class}}

\item{\code{data}}{\code{data.frame}}
}}

\examples{
require(stacomiR)
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
\dontrun{
  r_env<-new("report_env")
  r_env<-choice_c(r_env,
	  stationMesure=c("temp_gabion","coef_maree"),
	  datedebut="2008-01-01",
	  datefin="2008-12-31",
	  silent=FALSE)	
  r_env<-connect(r_env)
  
}	

data("r_env")
plot(r_env,silent=TRUE)
}
\seealso{
Other report Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
cedric.briand"at"eptb-vilaine.fr
}
\concept{report Objects}
\keyword{classes}
