\name{fit.model}
\alias{fit.model}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Fitting of parametric models using summary statistics}

\description{
Fits complex parametric models with intractable likelihood using the method proposed by Cox and Kartsonaki (2012).
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
fit.model(p, q, n, r, starting_values, h_vector, data_true, sim_data, features, n_iter,
print_results = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{p}{Number of parameters to be estimated.}
  \item{q}{Number of features / summary statistics.}
  \item{n}{Sample size. Usually equal to the number of observations in the data (\code{data_true}).}
  \item{r}{Number of simulations to be run at each design point, in each iteration.}
  \item{starting_values}{A vector of starting values for the parameter vector.}
  \item{h_vector}{A vector of spacings $h$.}
  \item{data_true}{The dataset.}
  \item{sim_data}{A function which simulates data using the model to be fitted.}
  \item{features}{A function which calculates the features / summary statistics.}
  \item{n_iter}{Number of iterations of the algorithm to be performed.}
  \item{print_results}{If \code{TRUE}, the estimates of the parameters are printed at each iteration.}
}

\details{
Function \code{sim_data} should simulate from the model, taking as arguments the sample size and the parameter vector.
Function \code{features} must take as an argument the simulated data generated by \code{sim_data} and calculate the features / summary statistics. The format of the dataset and the simulated data should be the same and should match the format needed by the function \code{features}. Function \code{features} must return a vector of length \code{q}.

%%  ~~ If necessary, more details than the description above ~~
}
\value{
	\item{estimates}{The estimates of the parameters.}
	\item{var_estimates}{The covariance matrix of the final estimates.}
	\item{L}{The matrix of coefficients L.}
	\item{sigma}{The covariance matrix of the features.}
}
\references{
Cox, D. R. and Kartsonaki, C. (2012). The fitting of complex parametric models. \emph{Biometrika}, \bold{99} (3): 741--747.
}
\author{Christiana Kartsonaki}

%\note{
%%  ~~further notes~~
%}

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
# estimate the mean of a N(2, 1) distribution

sim_function <- function(n, mu) {
	rnorm(n, unlist(mu), 1)
	}

features_function <- function(data) {
	a <- median(data)
	b <- sum(data) - (min(data) + max(data))
	c <- (min(data) + max(data)) / 2
	return(c(a, b, c))
	}
	
fit1 <- fit.model(p = 1, q = 3, n = 100, r = 100, starting_values = 5, h_vector = 0.1,
data_true = rnorm(100, 2, 1), sim_data = sim_function, features = features_function, 
n_iter = 50, print_results = TRUE) 
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
