// Generated by rstantools.  Do not edit by hand.

/*
    ssMousetrack is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ssMousetrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ssMousetrack.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_simulate_data_log_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_simulate_data_log");
    reader.add_event(114, 112, "end", "model_simulate_data_log");
    return reader;
}
template <typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, 1>
kronecker_simplified_J(const int& I,
                           const int& J,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        validate_non_negative_index("X", "I", I);
        validate_non_negative_index("X", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> X(I, J);
        stan::math::initialize(X, DUMMY_VAR__);
        stan::math::fill(X, DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("x_vec", "(I * J)", (I * J));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_vec((I * J));
        stan::math::initialize(x_vec, DUMMY_VAR__);
        stan::math::fill(x_vec, DUMMY_VAR__);
        current_statement_begin__ = 6;
        for (int i = 1; i <= I; ++i) {
            current_statement_begin__ = 7;
            stan::model::assign(X, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        rep_row_vector(get_base1(x, i, "x", 1), J), 
                        "assigning variable X");
        }
        current_statement_begin__ = 8;
        stan::math::assign(x_vec, to_vector(transpose(X)));
        current_statement_begin__ = 9;
        return stan::math::promote_scalar<fun_return_scalar_t__>(x_vec);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct kronecker_simplified_J_functor__ {
    template <typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, 1>
    operator()(const int& I,
                           const int& J,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return kronecker_simplified_J(I, J, x, pstream__);
    }
};
template <typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, 1>
kronecker_simplified_I(const int& I,
                           const int& J,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 13;
        validate_non_negative_index("X", "I", I);
        validate_non_negative_index("X", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> X(I, J);
        stan::math::initialize(X, DUMMY_VAR__);
        stan::math::fill(X, DUMMY_VAR__);
        current_statement_begin__ = 14;
        validate_non_negative_index("x_vec", "(I * J)", (I * J));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_vec((I * J));
        stan::math::initialize(x_vec, DUMMY_VAR__);
        stan::math::fill(x_vec, DUMMY_VAR__);
        current_statement_begin__ = 15;
        for (int i = 1; i <= I; ++i) {
            current_statement_begin__ = 16;
            stan::model::assign(X, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        to_row_vector(x), 
                        "assigning variable X");
        }
        current_statement_begin__ = 17;
        stan::math::assign(x_vec, to_vector(transpose(X)));
        current_statement_begin__ = 18;
        return stan::math::promote_scalar<fun_return_scalar_t__>(x_vec);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct kronecker_simplified_I_functor__ {
    template <typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, 1>
    operator()(const int& I,
                           const int& J,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return kronecker_simplified_I(I, J, x, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
rescale_data(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                 const T1__& min_x,
                 const T2__& max_x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 22;
        int I(0);
        (void) I;  // dummy to suppress unused var warning
        stan::math::fill(I, std::numeric_limits<int>::min());
        stan::math::assign(I,rows(x));
        current_statement_begin__ = 23;
        local_scalar_t__ max_Vx(DUMMY_VAR__);
        (void) max_Vx;  // dummy to suppress unused var warning
        stan::math::initialize(max_Vx, DUMMY_VAR__);
        stan::math::fill(max_Vx, DUMMY_VAR__);
        stan::math::assign(max_Vx,max(x));
        current_statement_begin__ = 24;
        local_scalar_t__ min_Vx(DUMMY_VAR__);
        (void) min_Vx;  // dummy to suppress unused var warning
        stan::math::initialize(min_Vx, DUMMY_VAR__);
        stan::math::fill(min_Vx, DUMMY_VAR__);
        stan::math::assign(min_Vx,min(x));
        current_statement_begin__ = 25;
        return stan::math::promote_scalar<fun_return_scalar_t__>(add(rep_vector(min_x, I), elt_multiply(elt_divide(subtract(x, min_Vx), rep_vector((max_Vx - min_Vx), I)), rep_vector((max_x - min_x), I))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct rescale_data_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                 const T1__& min_x,
                 const T2__& max_x, std::ostream* pstream__) const {
        return rescale_data(x, min_x, max_x, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
compute_deltay(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                   const int& I,
                   const T2__& pT,
                   const T3__& pD,
                   const T4__& pC, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 29;
        validate_non_negative_index("dx", "I", I);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> dx(I);
        stan::math::initialize(dx, DUMMY_VAR__);
        stan::math::fill(dx, DUMMY_VAR__);
        current_statement_begin__ = 30;
        for (int i = 1; i <= I; ++i) {
            current_statement_begin__ = 31;
            if (as_bool(logical_gte(get_base1(x, i, "x", 1), pC))) {
                current_statement_begin__ = 31;
                stan::model::assign(dx, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::fabs((get_base1(x, i, "x", 1) - pD)), 
                            "assigning variable dx");
            } else {
                current_statement_begin__ = 32;
                stan::model::assign(dx, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::fabs((get_base1(x, i, "x", 1) - pT)), 
                            "assigning variable dx");
            }
        }
        current_statement_begin__ = 33;
        return stan::math::promote_scalar<fun_return_scalar_t__>(dx);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct compute_deltay_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                   const int& I,
                   const T2__& pT,
                   const T3__& pD,
                   const T4__& pC, std::ostream* pstream__) const {
        return compute_deltay(x, I, pT, pD, pC, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_simulate_data_log
  : public stan::model::model_base_crtp<model_simulate_data_log> {
private:
        int I;
        int N;
        int J;
        int KK;
        std::vector<vector_d> Y;
        vector_d sigmaz;
        matrix_d bnds;
        matrix_d D;
        vector_d lambda_vec;
        matrix_d priors_matrix;
        double pT;
        double pD;
        double pC;
        double kappa_lb;
        double kappa_ub;
public:
    model_simulate_data_log(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_simulate_data_log(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_simulate_data_log_namespace::model_simulate_data_log";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "I", "int", context__.to_vec());
            I = int(0);
            vals_i__ = context__.vals_i("I");
            pos__ = 0;
            I = vals_i__[pos__++];
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "KK", "int", context__.to_vec());
            KK = int(0);
            vals_i__ = context__.vals_i("KK");
            pos__ = 0;
            KK = vals_i__[pos__++];
            current_statement_begin__ = 42;
            validate_non_negative_index("Y", "(I * J)", (I * J));
            validate_non_negative_index("Y", "N", N);
            context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(N,(I * J)));
            Y = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(N, Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J)));
            vals_r__ = context__.vals_r("Y");
            pos__ = 0;
            size_t Y_j_1_max__ = (I * J);
            size_t Y_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Y_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Y_k_0_max__; ++k_0__) {
                    Y[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("sigmaz", "I", I);
            context__.validate_dims("data initialization", "sigmaz", "vector_d", context__.to_vec(I));
            sigmaz = Eigen::Matrix<double, Eigen::Dynamic, 1>(I);
            vals_r__ = context__.vals_r("sigmaz");
            pos__ = 0;
            size_t sigmaz_j_1_max__ = I;
            for (size_t j_1__ = 0; j_1__ < sigmaz_j_1_max__; ++j_1__) {
                sigmaz(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "sigmaz", sigmaz, 0);
            current_statement_begin__ = 44;
            validate_non_negative_index("bnds", "(I * J)", (I * J));
            validate_non_negative_index("bnds", "3", 3);
            context__.validate_dims("data initialization", "bnds", "matrix_d", context__.to_vec((I * J),3));
            bnds = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((I * J), 3);
            vals_r__ = context__.vals_r("bnds");
            pos__ = 0;
            size_t bnds_j_2_max__ = 3;
            size_t bnds_j_1_max__ = (I * J);
            for (size_t j_2__ = 0; j_2__ < bnds_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < bnds_j_1_max__; ++j_1__) {
                    bnds(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "bnds", bnds, 0);
            check_less_or_equal(function__, "bnds", bnds, stan::math::pi());
            current_statement_begin__ = 45;
            validate_non_negative_index("D", "(I * J)", (I * J));
            validate_non_negative_index("D", "KK", KK);
            context__.validate_dims("data initialization", "D", "matrix_d", context__.to_vec((I * J),KK));
            D = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((I * J), KK);
            vals_r__ = context__.vals_r("D");
            pos__ = 0;
            size_t D_j_2_max__ = KK;
            size_t D_j_1_max__ = (I * J);
            for (size_t j_2__ = 0; j_2__ < D_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                    D(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 46;
            validate_non_negative_index("lambda_vec", "(I * J)", (I * J));
            context__.validate_dims("data initialization", "lambda_vec", "vector_d", context__.to_vec((I * J)));
            lambda_vec = Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J));
            vals_r__ = context__.vals_r("lambda_vec");
            pos__ = 0;
            size_t lambda_vec_j_1_max__ = (I * J);
            for (size_t j_1__ = 0; j_1__ < lambda_vec_j_1_max__; ++j_1__) {
                lambda_vec(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "lambda_vec", lambda_vec, 0);
            current_statement_begin__ = 47;
            validate_non_negative_index("priors_matrix", "KK", KK);
            validate_non_negative_index("priors_matrix", "5", 5);
            context__.validate_dims("data initialization", "priors_matrix", "matrix_d", context__.to_vec(KK,5));
            priors_matrix = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(KK, 5);
            vals_r__ = context__.vals_r("priors_matrix");
            pos__ = 0;
            size_t priors_matrix_j_2_max__ = 5;
            size_t priors_matrix_j_1_max__ = KK;
            for (size_t j_2__ = 0; j_2__ < priors_matrix_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < priors_matrix_j_1_max__; ++j_1__) {
                    priors_matrix(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "pT", "double", context__.to_vec());
            pT = double(0);
            vals_r__ = context__.vals_r("pT");
            pos__ = 0;
            pT = vals_r__[pos__++];
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "pD", "double", context__.to_vec());
            pD = double(0);
            vals_r__ = context__.vals_r("pD");
            pos__ = 0;
            pD = vals_r__[pos__++];
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "pC", "double", context__.to_vec());
            pC = double(0);
            vals_r__ = context__.vals_r("pC");
            pos__ = 0;
            pC = vals_r__[pos__++];
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "kappa_lb", "double", context__.to_vec());
            kappa_lb = double(0);
            vals_r__ = context__.vals_r("kappa_lb");
            pos__ = 0;
            kappa_lb = vals_r__[pos__++];
            check_greater_or_equal(function__, "kappa_lb", kappa_lb, 0);
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "kappa_ub", "double", context__.to_vec());
            kappa_ub = double(0);
            vals_r__ = context__.vals_r("kappa_ub");
            pos__ = 0;
            kappa_ub = vals_r__[pos__++];
            check_greater_or_equal(function__, "kappa_ub", kappa_ub, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 56;
            validate_non_negative_index("gamma", "KK", KK);
            num_params_r__ += KK;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_simulate_data_log() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 56;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "KK", KK);
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec(KK));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(KK);
        size_t gamma_j_1_max__ = KK;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 56;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_constrain(KK, lp__);
            else
                gamma = in__.vector_constrain(KK);
            // transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("b", "(I * J)", (I * J));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b((I * J));
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 62;
            stan::math::assign(b, multiply(D, gamma));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 60;
            size_t b_j_1_max__ = (I * J);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 68;
            for (int k = 1; k <= KK; ++k) {
                current_statement_begin__ = 69;
                if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 1))) {
                    current_statement_begin__ = 69;
                    lp_accum__.add(lognormal_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 2))) {
                    current_statement_begin__ = 70;
                    lp_accum__.add(normal_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 201))) {
                    current_statement_begin__ = 71;
                    lp_accum__.add(normal_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                    if (get_base1(gamma, k, "gamma", 1) < get_base1(priors_matrix, k, 4, "priors_matrix", 1)) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else if (get_base1(gamma, k, "gamma", 1) > get_base1(priors_matrix, k, 5, "priors_matrix", 1)) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-log_diff_exp(normal_cdf_log(get_base1(priors_matrix, k, 5, "priors_matrix", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)), normal_cdf_log(get_base1(priors_matrix, k, 4, "priors_matrix", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1))));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 3))) {
                    current_statement_begin__ = 72;
                    lp_accum__.add(chi_square_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 4))) {
                    current_statement_begin__ = 73;
                    lp_accum__.add(inv_chi_square_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 5))) {
                    current_statement_begin__ = 74;
                    lp_accum__.add(gamma_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 6))) {
                    current_statement_begin__ = 75;
                    lp_accum__.add(pareto_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                } else if (as_bool(logical_eq(get_base1(priors_matrix, k, 1, "priors_matrix", 1), 7))) {
                    current_statement_begin__ = 76;
                    lp_accum__.add(uniform_log<propto__>(get_base1(gamma, k, "gamma", 1), get_base1(priors_matrix, k, 2, "priors_matrix", 1), get_base1(priors_matrix, k, 3, "priors_matrix", 1)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("b");
        names__.push_back("z");
        names__.push_back("mu");
        names__.push_back("y_sim");
        names__.push_back("dy_sim");
        names__.push_back("z_vec");
        names__.push_back("kappas");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(KK);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(I);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back((I * J));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_simulate_data_log_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_constrain(KK);
        size_t gamma_j_1_max__ = KK;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("b", "(I * J)", (I * J));
            Eigen::Matrix<double, Eigen::Dynamic, 1> b((I * J));
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 62;
            stan::math::assign(b, multiply(D, gamma));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t b_j_1_max__ = (I * J);
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 81;
            validate_non_negative_index("z", "I", I);
            validate_non_negative_index("z", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z(N, Eigen::Matrix<double, Eigen::Dynamic, 1>(I));
            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z, DUMMY_VAR__);
            current_statement_begin__ = 82;
            validate_non_negative_index("mu", "(I * J)", (I * J));
            validate_non_negative_index("mu", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu(N, Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J)));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 83;
            validate_non_negative_index("y_sim", "(I * J)", (I * J));
            validate_non_negative_index("y_sim", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > y_sim(N, Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J)));
            stan::math::initialize(y_sim, DUMMY_VAR__);
            stan::math::fill(y_sim, DUMMY_VAR__);
            current_statement_begin__ = 84;
            validate_non_negative_index("dy_sim", "(I * J)", (I * J));
            validate_non_negative_index("dy_sim", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > dy_sim(N, Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J)));
            stan::math::initialize(dy_sim, DUMMY_VAR__);
            stan::math::fill(dy_sim, DUMMY_VAR__);
            current_statement_begin__ = 85;
            validate_non_negative_index("z_vec", "(I * J)", (I * J));
            Eigen::Matrix<double, Eigen::Dynamic, 1> z_vec((I * J));
            stan::math::initialize(z_vec, DUMMY_VAR__);
            stan::math::fill(z_vec, DUMMY_VAR__);
            current_statement_begin__ = 86;
            validate_non_negative_index("kappas", "(I * J)", (I * J));
            validate_non_negative_index("kappas", "N", N);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > kappas(N, Eigen::Matrix<double, Eigen::Dynamic, 1>((I * J)));
            stan::math::initialize(kappas, DUMMY_VAR__);
            stan::math::fill(kappas, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 89;
            stan::model::assign(z, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        rep_vector(1e-04, I), 
                        "assigning variable z");
            current_statement_begin__ = 90;
            for (int n = 2; n <= N; ++n) {
                current_statement_begin__ = 91;
                for (int i = 1; i <= I; ++i) {
                    current_statement_begin__ = 92;
                    stan::model::assign(z, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                normal_rng(get_base1(get_base1(z, (n - 1), "z", 1), i, "z", 2), get_base1(sigmaz, i, "sigmaz", 1), base_rng__), 
                                "assigning variable z");
                }
            }
            current_statement_begin__ = 97;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 98;
                if (as_bool(logical_eq(n, 1))) {
                    current_statement_begin__ = 99;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                rep_vector((stan::math::pi() / 2), (I * J)), 
                                "assigning variable mu");
                    current_statement_begin__ = 100;
                    stan::model::assign(dy_sim, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                compute_deltay(get_base1(mu, n, "mu", 1), (I * J), pT, pD, pC, pstream__), 
                                "assigning variable dy_sim");
                    current_statement_begin__ = 101;
                    stan::model::assign(kappas, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                rep_vector(kappa_ub, (I * J)), 
                                "assigning variable kappas");
                } else {
                    current_statement_begin__ = 103;
                    stan::math::assign(z_vec, kronecker_simplified_J(I, J, get_base1(z, n, "z", 1), pstream__));
                    current_statement_begin__ = 104;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(bnds, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "bnds"), elt_divide(stan::model::rvalue(bnds, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), "bnds"), add(1, stan::math::exp(subtract(b, z_vec))))), 
                                "assigning variable mu");
                    current_statement_begin__ = 105;
                    stan::model::assign(dy_sim, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(compute_deltay(get_base1(mu, n, "mu", 1), (I * J), pT, pD, pC, pstream__), multi_normal_rng(rep_vector(0, (I * J)), diag_matrix(rep_vector(2.5e-2, (I * J))), base_rng__)), 
                                "assigning variable dy_sim");
                    current_statement_begin__ = 106;
                    stan::model::assign(kappas, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                rescale_data(stan::math::exp(elt_multiply(lambda_vec, get_base1(dy_sim, n, "dy_sim", 1))), kappa_lb, kappa_ub, pstream__), 
                                "assigning variable kappas");
                }
                current_statement_begin__ = 108;
                for (int q = 1; q <= (I * J); ++q) {
                    current_statement_begin__ = 109;
                    stan::model::assign(y_sim, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                von_mises_rng(get_base1(get_base1(mu, n, "mu", 1), q, "mu", 2), get_base1(get_base1(kappas, n, "kappas", 1), q, "kappas", 2), base_rng__), 
                                "assigning variable y_sim");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 81;
            size_t z_j_1_max__ = I;
            size_t z_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < z_k_0_max__; ++k_0__) {
                    vars__.push_back(z[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 82;
            size_t mu_j_1_max__ = (I * J);
            size_t mu_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    vars__.push_back(mu[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 83;
            size_t y_sim_j_1_max__ = (I * J);
            size_t y_sim_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_sim_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                    vars__.push_back(y_sim[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 84;
            size_t dy_sim_j_1_max__ = (I * J);
            size_t dy_sim_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < dy_sim_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < dy_sim_k_0_max__; ++k_0__) {
                    vars__.push_back(dy_sim[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 85;
            size_t z_vec_j_1_max__ = (I * J);
            for (size_t j_1__ = 0; j_1__ < z_vec_j_1_max__; ++j_1__) {
                vars__.push_back(z_vec(j_1__));
            }
            current_statement_begin__ = 86;
            size_t kappas_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < kappas_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "kappas[i_0__]", kappas[i_0__], kappa_lb);
                check_less_or_equal(function__, "kappas[i_0__]", kappas[i_0__], kappa_ub);
            }
            size_t kappas_j_1_max__ = (I * J);
            size_t kappas_k_0_max__ = N;
            for (size_t j_1__ = 0; j_1__ < kappas_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < kappas_k_0_max__; ++k_0__) {
                    vars__.push_back(kappas[k_0__](j_1__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_simulate_data_log";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = KK;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = (I * J);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t z_j_1_max__ = I;
        size_t z_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_j_1_max__ = (I * J);
        size_t mu_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_sim_j_1_max__ = (I * J);
        size_t y_sim_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < y_sim_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_sim" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t dy_sim_j_1_max__ = (I * J);
        size_t dy_sim_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < dy_sim_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < dy_sim_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dy_sim" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t z_vec_j_1_max__ = (I * J);
        for (size_t j_1__ = 0; j_1__ < z_vec_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_vec" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kappas_j_1_max__ = (I * J);
        size_t kappas_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < kappas_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < kappas_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kappas" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = KK;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = (I * J);
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t z_j_1_max__ = I;
        size_t z_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_j_1_max__ = (I * J);
        size_t mu_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_sim_j_1_max__ = (I * J);
        size_t y_sim_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < y_sim_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_sim" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t dy_sim_j_1_max__ = (I * J);
        size_t dy_sim_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < dy_sim_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < dy_sim_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dy_sim" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t z_vec_j_1_max__ = (I * J);
        for (size_t j_1__ = 0; j_1__ < z_vec_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_vec" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kappas_j_1_max__ = (I * J);
        size_t kappas_k_0_max__ = N;
        for (size_t j_1__ = 0; j_1__ < kappas_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < kappas_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kappas" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_simulate_data_log_namespace::model_simulate_data_log stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
