% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_tour.r
\name{rotate_manip_space}
\alias{rotate_manip_space}
\title{Rotate and return the manipulation space}
\usage{
rotate_manip_space(manip_space, theta, phi)
}
\arguments{
\item{manip_space}{A (p, d+1) dim manipulation space to be rotated.}

\item{theta}{Angle in radians of rotation "in-plane", on the XY plane of the
reference frame. Typically set from manip_type in \code{proj_data()}.}

\item{phi}{Angle in radians of rotation "out-of-plane", the z axis of the
reference frame. Effectively changes the norm of XY contributions of the
manip_var.}
}
\value{
A (p, d+1) orthonormal matrix of the rotated (manipulation) space.
}
\description{
Typically called by \code{manual_tour()}. Rotates a (p, d+1) manipulation space
matrix by (d+1, d+1) rotation matrix, returning (p, d+1) matrix rotation
space. The first 2 variables of which are the linear combination of the
variables for a 2d projection.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[,1:6])

rb  <- basis_random(n = ncol(flea_std))
msp <- create_manip_space(basis = rb, manip_var = 4) 
rotate_manip_space(msp, theta = runif(1, max = 2 * pi), 
                   phi = runif(1, max = 2 * pi) )
}
