% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialR2.R
\name{partialR2}
\alias{partialR2}
\title{Coefficient of Partial Determination}
\usage{
partialR2(y, x = NULL, evecs)
}
\arguments{
\item{y}{response variable}

\item{x}{vector/ matrix of regressors}

\item{evecs}{(selected) eigenvectors}
}
\value{
Vector of partial R-squared values of the eigenvectors.
}
\description{
This function computes the partial R-squared of all
selected eigenvectors in a spatially filtered linear regression model.
}
\note{
The function assumes a linear regression model. Since the
eigenvectors are mutually uncorrelated, \code{partialR2} evaluates
them sequentially. In generalized linear models, the presence of a link
function can corrupt the uncorrelatedness of the eigenvectors.
}
\examples{
data(fakedata)
y <- fakedataset$x1
x <- fakedataset$x2

# get eigenvectors
E <-getEVs(W=W,covars=NULL)$vectors

(out <- partialR2(y=y,x=x,evecs=E[,1:5]))


}
\seealso{
\code{\link{lmFilter}}, \code{\link{getEVs}}
}
\author{
Sebastian Juhl
}
