\name{drawBW}
\alias{drawBW}
 
\title{
BW and percentile ratios plot
}
\description{
This function is used to plot BW and percentile ratios
}
\usage{
drawBW(BW,
      perc,
      X,
      startP = -1,
      endP = -1,
      groupLabel = NULL,
      highBound = -1,
      lowBound = -1,
      nAxisPos = 4,
      offside = 0)
}
 
\arguments{
  \item{BW}{
An array of the BW ratios.
}
  \item{perc}{
An array of the percentile ratios.
}
  \item{X}{
The spectral dataset in matrix format in which each row contains a single sample.
}
  \item{startP}{
The starting point of the segment. If it is -1, the starting point is from begining of the spectra.
}
  \item{endP}{
The ending point of the segment. If it is -1, the ending point is the last point of the spectra.
}
  \item{groupLabel}{
The default value is NULL, it means that a single spectrum has a distinct color. Otherwise, the spectra is colored by their label.
}
  \item{highBound}{
Default value is -1, that means the plot covers also the highest intesity peaks in the figure.
If the users want to limit the upper height of the figure, set this parameter by the limited value.
}
  \item{lowBound}{
Default value is -1, that means the plot covers also the lowest intesity peaks in the figure.
If the users want to limit the under height of the figure, set this parameter by the limited value.
}
  \item{nAxisPos}{
The number of ticks that will be displayed in the horizontal axis.
}
  \item{offside}{
The offside of values in x-axis for display.
}
}
\details{
This function is used to plot BW and percentile ratios 
}
\value{
    Return a plot containing both the BW and the spectra.
}
\author{
Trung Nghia Vu 
}

\seealso{
\code{\link{drawSpec}} 
}
\examples{ 
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;


peakList <- detectSpecPeaks(X,
  nDivRange = c(128),                
  scales = seq(1, 16, 2),
  baselineThresh = 50000,
  SNR.Th = -1,
    verbose=FALSE
);


resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;


maxShift = 50;
Y <- dohCluster(X,
                peakList = peakList,
                refInd = refInd,
                maxShift  = maxShift,
                acceptLostPeak = TRUE, verbose=FALSE);

# find the BW-statistic
BW = BWR(Y, groupLabel);

N = 100;
alpha = 0.05;

# create sampled H0 and export to file
H0 = createNullSampling(Y, groupLabel, N = N,verbose=FALSE)

#compute percentile of alpha
perc = double(ncol(Y));
alpha_corr = alpha/sum(returnLocalMaxima(Y[2,])$pkMax>50000);
for (i in 1 : length(perc)){    
    perc[i] = quantile(H0[,i],1-alpha_corr, type = 3);
}

drawBW(BW, perc,Y, groupLabel = groupLabel)

}
 
 
\keyword{ BW }
\keyword{ plot } 
