% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_analysis_netlogo.R
\name{oat_process_netlogo_result}
\alias{oat_process_netlogo_result}
\title{Takes a Netlogo behaviour space file and performs a robustness analysis from that simulation data}
\usage{
oat_process_netlogo_result(FILEPATH, NETLOGO_BEHAVIOURSPACEFILE,
  PARAMETERS, BASELINE, PMIN, PMAX, PINC, MEASURES, RESULTFILENAME,
  ATESTRESULTSFILENAME, TIMESTEP)
}
\arguments{
\item{FILEPATH}{Location where the behaviour space results can be found}

\item{NETLOGO_BEHAVIOURSPACEFILE}{The name of the file produced by Netlogo for Parameter Robustness (Technique 2). This is the result file that is analysed.}

\item{PARAMETERS}{Array containing the names of the parameters for which parameter samples were be generated}

\item{BASELINE}{Array containing the baseline, or calibrated value, of each parameter.}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space.}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space.}

\item{PINC}{Array containing the increment value that should be applied for each parameter. For example, a parameter could have a minimum value of 10, and maximum value of 100, and be incremented by 10.}

\item{MEASURES}{Array containing the names of the Netlogo output measures which are used to analyse the simulation.}

\item{RESULTFILENAME}{Name of the results summary file that should be produced when analysing the Netlogo results}

\item{ATESTRESULTSFILENAME}{File name of the ATests result summary file created by \code{oat_analyseAllParams}}

\item{TIMESTEP}{The timestep of the Netlogo simulation being analysed.}
}
\description{
From a Netlogo behaviour space file, extracts the required timepoint
information from it, storing this in a Spartan compatible CSV file.
This CSV file is then processed using the methods described in
\code{oat_csv_result_file_analysis}, with A-Test scores determined
for each value assigned to each parameter. Once this method has been
called, the researcher should use the \code{oat_graphATestsForSampleSize}
and \code{oat_plotResultDistribution} methods to graph the results.
}
