% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_converters.R
\name{as_cpt}
\alias{as_cpt}
\alias{as_cpt.sparta}
\title{As cpt}
\usage{
as_cpt(x, y)

\method{as_cpt}{sparta}(x, y)
}
\arguments{
\item{x}{sparta object}

\item{y}{the conditioning variables}
}
\description{
Turn a sparta into a conditional probability table
}
\examples{
x <- array(
  c(1,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

sx <- as_sparta(x)

# A joint probability table p(a, b, c)
as_cpt(sx, character(0))
# the same as normalize
normalize(sx)

# A conditional probability table p(a, c | b)
pacb <- as_cpt(sx, "b")

# The probability distribution when b = b1
slice(pacb, c(b = "b1"))

}
