/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import sparklyr.Backend$;
import sparklyr.Backend$GatewayOperations$;
import sparklyr.BackendChannel;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.Serializer;
import sparklyr.Utils$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u001a5\u0001]BQA\u0010\u0001\u0005\u0002}BaA\u0011\u0001!B\u0013\u0019\u0005B\u0002$\u0001A\u0003&1\t\u0003\u0004H\u0001\u0001\u0006Ka\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015B\"\t\r%\u0003\u0001\u0015)\u0003K\u0011\u0019A\u0006\u0001)Q\u0005\u001b\"1\u0011\f\u0001Q\u0001\niCaA\u001a\u0001!B\u0013\u0019\u0005BB4\u0001A\u0003&\u0001\u000e\u0003\u0004l\u0001\u0001\u0006K\u0001\u001c\u0005\u0007e\u0002\u0001\u000b\u0015\u00025\t\rM\u0004\u0001\u0015)\u0003i\u0011\u0019!\b\u0001)Q\u0005Q\"1Q\u000f\u0001Q!\n5CaA\u001e\u0001!B\u00139\b\u0002CA\u0002\u0001\u0001\u0006K!!\u0002\t\u0011\u0005-\u0001\u0001)Q\u0005\u0003\u001bA\u0001\"a\u0005\u0001A\u0003&\u0011Q\u0003\u0005\b\u00037\u0001\u0001\u0015)\u0003[\u0011!\ti\u0002\u0001Q!\n\u0005}\u0001bBA\u0016\u0001\u0011\u0005\u0011QF\u0004\b\u0003s\u0001\u0001\u0012AA\u001e\r\u001d\ty\u0004\u0001E\u0001\u0003\u0003BaA\u0010\r\u0005\u0002\u0005%\u0003\"CA&1\t\u0007I\u0011AA'\u0011!\t9\u0006\u0007Q\u0001\n\u0005=\u0003\"CA-1\t\u0007I\u0011AA'\u0011!\tY\u0006\u0007Q\u0001\n\u0005=\u0003\"CA/1\t\u0007I\u0011AA'\u0011!\ty\u0006\u0007Q\u0001\n\u0005=\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAK\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\t)\f\u0001C\u0001\u0003gCq!a.\u0001\t\u0003\t\u0019\fC\u0004\u0002:\u0002!\t!a-\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011Q\u0019\u0001\u0005\u0002\u0005M\u0006bBAd\u0001\u0011\u0005\u0011\u0011Z\u0004\b\u0003\u001f$\u0004\u0012AAi\r\u0019\u0019D\u0007#\u0001\u0002T\"1a\b\rC\u0001\u0003+Dq!a61\t\u0003\tINA\u0004CC\u000e\\WM\u001c3\u000b\u0003U\n\u0001b\u001d9be.d\u0017P]\u0002\u0001'\t\u0001\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0003\"!\u0011\u0001\u000e\u0003Q\n\u0011\"[:TKJ4\u0018nY3\u0011\u0005e\"\u0015BA#;\u0005\u001d\u0011un\u001c7fC:\f\u0001\"[:SK6|G/Z\u0001\tSN<vN]6fe\u00069\u0011n\u001d\"bi\u000eD\u0017\u0001B1sON\u00042!O&N\u0013\ta%HA\u0003BeJ\f\u0017\u0010\u0005\u0002O+:\u0011qj\u0015\t\u0003!jj\u0011!\u0015\u0006\u0003%Z\na\u0001\u0010:p_Rt\u0014B\u0001+;\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QS\u0014a\u00035pgR\u001cuN\u001c;fqR\f\u0011\"[:Sk:t\u0017N\\4\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016AB1u_6L7M\u0003\u0002`A\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002f9\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fA\"[:SK\u001eL7\u000f^3sK\u0012\f1bZ1uK^\f\u0017\u0010U8siB\u0011\u0011([\u0005\u0003Uj\u00121!\u00138u\u0003M9\u0017\r^3xCf\u001cVM\u001d<feN{7m[3u!\ti\u0007/D\u0001o\u0015\ty'-A\u0002oKRL!!\u001d8\u0003\u0019M+'O^3s'>\u001c7.\u001a;\u0002\tA|'\u000f^\u0001\ng\u0016\u001c8/[8o\u0013\u0012\f\u0011cY8o]\u0016\u001cG/[8o)&lWm\\;u\u0003%\u0011\u0017\r^2i\r&dW-\u0001\u0002tGB\u0011\u0001p`\u0007\u0002s*\u0011!p_\u0001\u0006gB\f'o\u001b\u0006\u0003yv\fa!\u00199bG\",'\"\u0001@\u0002\u0007=\u0014x-C\u0002\u0002\u0002e\u0014Ab\u00159be.\u001cuN\u001c;fqR\f1b]3tg&|gn]'baB)a*a\u0002iQ&\u0019\u0011\u0011B,\u0003\u00075\u000b\u0007/A\u0006j]\u0016$\u0018\t\u001a3sKN\u001c\bcA7\u0002\u0010%\u0019\u0011\u0011\u00038\u0003\u0017%sW\r^!eIJ,7o]\u0001\u0007Y><w-\u001a:\u0011\u0007\u0005\u000b9\"C\u0002\u0002\u001aQ\u0012a\u0001T8hO\u0016\u0014\u0018!D8oK\u000e{gN\\3di&|g.\u0001\beK\u001a\fW\u000f\u001c;Ue\u0006\u001c7.\u001a:\u0011\u000be\n\t#!\n\n\u0007\u0005\r\"H\u0001\u0004PaRLwN\u001c\t\u0004\u0003\u0006\u001d\u0012bAA\u0015i\t\u0001\"JV'PE*,7\r\u001e+sC\u000e\\WM]\u0001\u000bg\u0016$HK]1dW\u0016\u0014H\u0003BA\u0018\u0003k\u00012!OA\u0019\u0013\r\t\u0019D\u000f\u0002\u0005+:LG\u000fC\u0004\u00028Y\u0001\r!!\n\u0002\u000fQ\u0014\u0018mY6fe\u0006\tr)\u0019;fo\u0006Lx\n]3sCRLwN\\:\u0011\u0007\u0005u\u0002$D\u0001\u0001\u0005E9\u0015\r^3xCf|\u0005/\u001a:bi&|gn]\n\u00041\u0005\r\u0003cA\u001d\u0002F%\u0019\u0011q\t\u001e\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\u0003\u0003w\t\u0001bR3u!>\u0014Ho]\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002T5\t\u0001$\u0003\u0003\u0002V\u0005\u0015#!\u0002,bYV,\u0017!C$fiB{'\u000f^:!\u0003A\u0011VmZ5ti\u0016\u0014\u0018J\\:uC:\u001cW-A\tSK\u001eL7\u000f^3s\u0013:\u001cH/\u00198dK\u0002\n!#\u00168sK\u001eL7\u000f^3s\u0013:\u001cH/\u00198dK\u0006\u0019RK\u001c:fO&\u001cH/\u001a:J]N$\u0018M\\2fA\u0005yq-\u001a;Ta\u0006\u00148nQ8oi\u0016DH\u000fF\u0001x\u0003\u001d9W\r\u001e)peR$\u0012\u0001[\u0001\u0010g\u0016$8\u000b]1sW\u000e{g\u000e^3yiR!\u0011qFA7\u0011\u0019\tyG\ta\u0001o\u0006\u0019an]2\u0002\u000fM,G/\u0011:hgR!\u0011qFA;\u0011\u0019\t9h\ta\u0001\u0015\u0006I\u0011M]4t!\u0006\u0014\u0018-\\\u0001\bg\u0016$H+\u001f9f))\ty#! \u0002\u0002\u0006\u0015\u0015\u0011\u0012\u0005\u0007\u0003\u007f\"\u0003\u0019A\"\u0002\u001d%\u001c8+\u001a:wS\u000e,\u0007+\u0019:b[\"1\u00111\u0011\u0013A\u0002\r\u000bQ\"[:SK6|G/\u001a)be\u0006l\u0007BBADI\u0001\u00071)A\u0007jg^{'o[3s!\u0006\u0014\u0018-\u001c\u0005\u0007\u0003\u0017#\u0003\u0019A\"\u0002\u0019%\u001c()\u0019;dQB\u000b'/Y7\u0002\u001dM,G\u000fS8ti\u000e{g\u000e^3yiR!\u0011qFAI\u0011\u0019\t\u0019*\na\u0001\u001b\u0006\u0001\u0002n\\:u\u0007>tG/\u001a=u!\u0006\u0014\u0018-\\\u0001\u0005S:LG\u000f\u0006\u0005\u00020\u0005e\u0015QTAQ\u0011\u0019\tYJ\na\u0001Q\u0006I\u0001o\u001c:u!\u0006\u0014\u0018-\u001c\u0005\u0007\u0003?3\u0003\u0019\u00015\u0002\u001dM,7o]5p]&#\u0007+\u0019:b[\"1\u00111\u0015\u0014A\u0002!\facY8o]\u0016\u001cG/[8o)&lWm\\;u!\u0006\u0014\u0018-\u001c\u000b\u000b\u0003_\t9+!+\u0002,\u00065\u0006BBANO\u0001\u0007\u0001\u000e\u0003\u0004\u0002 \u001e\u0002\r\u0001\u001b\u0005\u0007\u0003G;\u0003\u0019\u00015\t\r\u0005=v\u00051\u0001N\u00035\u0011\u0017\r^2i\r&dW\rU1uQ\u0006)!-\u0019;dQR\u0011\u0011qF\u0001\u0004eVt\u0017aC5oSRluN\\5u_J\fAAY5oI\u0006A!/Z4jgR,'\u000fF\u0004D\u0003\u007f\u000b\t-a1\t\u000b\u001dd\u0003\u0019\u00015\t\u000bMd\u0003\u0019\u00015\t\u000bId\u0003\u0019\u00015\u0002\u0013Q,'/\\5oCR,\u0017AC;oe\u0016<\u0017n\u001d;feR)1)a3\u0002N\")qM\fa\u0001Q\")1O\fa\u0001Q\u00069!)Y2lK:$\u0007CA!1'\t\u0001\u0004\b\u0006\u0002\u0002R\u0006!Q.Y5o)\u0011\ty#a7\t\u000b%\u0013\u0004\u0019\u0001&")
public class Backend {
    private volatile Backend$GatewayOperations$ GatewayOperations$module;
    public boolean sparklyr$Backend$$isService = false;
    public boolean sparklyr$Backend$$isRemote = false;
    public boolean sparklyr$Backend$$isWorker = false;
    private boolean isBatch = false;
    public String[] sparklyr$Backend$$args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    public String sparklyr$Backend$$hostContext = null;
    public final AtomicBoolean sparklyr$Backend$$isRunning = new AtomicBoolean(true);
    private boolean isRegistered = false;
    private int gatewayPort = 0;
    public ServerSocket sparklyr$Backend$$gatewayServerSocket = null;
    public int sparklyr$Backend$$port = 0;
    public int sparklyr$Backend$$sessionId = 0;
    public int sparklyr$Backend$$connectionTimeout = 60;
    public String sparklyr$Backend$$batchFile = "";
    private SparkContext sc = null;
    public Map<Object, Object> sparklyr$Backend$$sessionsMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    private InetAddress inetAddress = InetAddress.getLoopbackAddress();
    public Logger sparklyr$Backend$$logger = new Logger("Session", 0);
    public AtomicBoolean sparklyr$Backend$$oneConnection = new AtomicBoolean(false);
    public Option<JVMObjectTracker> sparklyr$Backend$$defaultTracker = None$.MODULE$;

    public static void main(String[] stringArray) {
        Backend$.MODULE$.main(stringArray);
    }

    public Backend$GatewayOperations$ GatewayOperations() {
        if (this.GatewayOperations$module == null) {
            this.GatewayOperations$lzycompute$1();
        }
        return this.GatewayOperations$module;
    }

    public void setTracker(JVMObjectTracker tracker) {
        this.sparklyr$Backend$$defaultTracker = Option$.MODULE$.apply((Object)tracker);
    }

    public SparkContext getSparkContext() {
        return this.sc;
    }

    public int getPort() {
        return this.sparklyr$Backend$$port;
    }

    public void setSparkContext(SparkContext nsc) {
        this.sc = nsc;
    }

    public void setArgs(String[] argsParam) {
        this.sparklyr$Backend$$args = argsParam;
    }

    public void setType(boolean isServiceParam, boolean isRemoteParam, boolean isWorkerParam, boolean isBatchParam) {
        this.sparklyr$Backend$$isService = isServiceParam;
        this.sparklyr$Backend$$isRemote = isRemoteParam;
        this.sparklyr$Backend$$isWorker = isWorkerParam;
        this.isBatch = isBatchParam;
    }

    public void setHostContext(String hostContextParam) {
        this.sparklyr$Backend$$hostContext = hostContextParam;
    }

    public void init(int portParam, int sessionIdParam, int connectionTimeoutParam) {
        this.init(portParam, sessionIdParam, connectionTimeoutParam, "");
    }

    public void init(int portParam, int sessionIdParam, int connectionTimeoutParam, String batchFilePath) {
        block12: {
            block11: {
                this.sparklyr$Backend$$port = portParam;
                this.sparklyr$Backend$$sessionId = sessionIdParam;
                this.sparklyr$Backend$$connectionTimeout = connectionTimeoutParam;
                this.sparklyr$Backend$$batchFile = batchFilePath;
                this.sparklyr$Backend$$logger = new Logger("Session", this.sparklyr$Backend$$sessionId);
                this.sparklyr$Backend$$logger.log(new StringBuilder(24).append("is starting under ").append(InetAddress.getLoopbackAddress().getHostAddress()).append(" port ").append(this.sparklyr$Backend$$port).toString());
                if (this.sparklyr$Backend$$isRemote) {
                    this.sparklyr$Backend$$logger.log("is configuring for remote connections");
                    byte[] anyIpAddress = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                    this.inetAddress = InetAddress.getByAddress(anyIpAddress);
                }
                try {
                    if (this.sparklyr$Backend$$isWorker) {
                        this.sparklyr$Backend$$gatewayServerSocket = new ServerSocket(0, 1, this.inetAddress);
                        this.sparklyr$Backend$$port = this.sparklyr$Backend$$gatewayServerSocket.getLocalPort();
                    } else if (Utils$.MODULE$.portIsAvailable(this.sparklyr$Backend$$port, this.inetAddress)) {
                        this.sparklyr$Backend$$logger.log(new StringBuilder(24).append("found port ").append(this.sparklyr$Backend$$port).append(" is available").toString());
                        this.sparklyr$Backend$$logger = new Logger("Gateway", this.sparklyr$Backend$$sessionId);
                        this.sparklyr$Backend$$gatewayServerSocket = new ServerSocket(this.sparklyr$Backend$$port, 100, this.inetAddress);
                    } else {
                        this.sparklyr$Backend$$logger.log(new StringBuilder(28).append("found port ").append(this.sparklyr$Backend$$port).append(" is not available").toString());
                        this.sparklyr$Backend$$logger = new Logger("Backend", this.sparklyr$Backend$$sessionId);
                        if (this.sparklyr$Backend$$isWorker) {
                            this.sparklyr$Backend$$logger = new Logger("Worker", this.sparklyr$Backend$$sessionId);
                        }
                        int newPort = Utils$.MODULE$.nextPort(this.sparklyr$Backend$$port, this.inetAddress);
                        this.sparklyr$Backend$$logger.log(new StringBuilder(24).append("found port ").append(newPort).append(" is available").toString());
                        this.sparklyr$Backend$$gatewayServerSocket = new ServerSocket(newPort, 1, this.inetAddress);
                        this.gatewayPort = this.sparklyr$Backend$$port;
                        this.sparklyr$Backend$$port = this.sparklyr$Backend$$gatewayServerSocket.getLocalPort();
                        boolean success = this.register(this.gatewayPort, this.sparklyr$Backend$$sessionId, this.sparklyr$Backend$$port);
                        if (!success) {
                            this.sparklyr$Backend$$logger.logError(new StringBuilder(35).append("failed to register on gateway port ").append(this.gatewayPort).toString());
                            if (!this.sparklyr$Backend$$isService) {
                                System.exit(1);
                            }
                        }
                        this.isRegistered = true;
                    }
                    this.sparklyr$Backend$$gatewayServerSocket.setSoTimeout(0);
                }
                catch (IOException e) {
                    this.sparklyr$Backend$$logger.logError("is shutting down from init() with exception ", e);
                    if (this.sparklyr$Backend$$isService) break block11;
                    System.exit(1);
                }
            }
            if (!this.sparklyr$Backend$$isWorker) {
                this.run();
            }
            if (this.sparklyr$Backend$$isService) break block12;
            System.exit(0);
        }
    }

    public void batch() {
        new Thread(this){
            private final /* synthetic */ Backend $outer;

            public void run() {
                block6: {
                    try {
                        this.$outer.sparklyr$Backend$$logger.log("is starting batch rscript");
                        Rscript rscript = new Rscript(this.$outer.sparklyr$Backend$$logger);
                        String sparklyrGateway = new StringBuilder(22).append("sparklyr://localhost:").append(((Object)BoxesRunTime.boxToInteger((int)this.$outer.sparklyr$Backend$$port)).toString()).append("/").append(this.$outer.sparklyr$Backend$$sessionId).toString();
                        this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(31).append("will be using rscript gateway: ").append(sparklyrGateway).toString());
                        File sourceFile = new File("sparklyr-batch.R");
                        if (!sourceFile.exists()) {
                            this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(43).append("tried to find source under working folder: ").append(new File(".").getAbsolutePath()).toString());
                            this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(42).append("tried to find source under working files: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(".").listFiles())).mkString(",")).toString());
                            sourceFile = new File(new StringBuilder(16).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rscript.getScratchDir()), File.separator)).append("sparklyr-batch.R").toString());
                            if (!sourceFile.exists()) {
                                this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(43).append("tried to find source under scratch folder: ").append(rscript.getScratchDir().getAbsolutePath()).toString());
                                this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(42).append("tried to find source under scratch files: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rscript.getScratchDir().listFiles())).mkString(",")).toString());
                                sourceFile = new File(this.$outer.sparklyr$Backend$$batchFile);
                            }
                        }
                        Iterator sourceLines = Source$.MODULE$.fromFile(sourceFile, Codec$.MODULE$.fallbackSystemCodec()).getLines();
                        File modifiedFile = new File(new StringBuilder(20).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rscript.getScratchDir()), File.separator)).append("sparklyr-batch-mod.R").toString());
                        FileWriter outStream = new FileWriter(modifiedFile);
                        outStream.write(new StringBuilder(37).append("options(sparklyr.connect.master = \"").append(sparklyrGateway).append("\")").toString());
                        outStream.write("\n\n");
                        sourceLines.foreach((Function1 & Serializable & scala.Serializable)line -> {
                            $anon$1.$anonfun$run$1(outStream, line);
                            return BoxedUnit.UNIT;
                        });
                        outStream.flush();
                        this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(30).append("wrote modified batch rscript: ").append(modifiedFile.getAbsolutePath()).toString());
                        Map customEnv = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                        rscript.init((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.sparklyr$Backend$$args)).toList(), modifiedFile.getAbsolutePath(), (Map<String, String>)customEnv, (Map<String, String>)options);
                    }
                    catch (InvocationTargetException e) {
                        Throwable throwable = e.getCause();
                        if (throwable instanceof Exception) {
                            Exception exception = (Exception)throwable;
                            this.$outer.sparklyr$Backend$$logger.logError("failed to invoke batch rscript: ", exception);
                            System.exit(1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block6;
                        }
                        this.$outer.sparklyr$Backend$$logger.logError("failed to invoke batch rscript: ", e);
                        System.exit(1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Exception e) {
                        this.$outer.sparklyr$Backend$$logger.logError("failed to run batch rscript: ", e);
                        System.exit(1);
                    }
                }
            }

            public static final /* synthetic */ void $anonfun$run$1(FileWriter outStream$1, String line) {
                outStream$1.write(new StringBuilder(1).append(line).append("\n").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("starting batch rscript thread");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(java.io.FileWriter java.lang.String )}, serializedLambda);
            }
        }.start();
    }

    public void run() {
        block5: {
            try {
                if (this.isBatch) {
                    SparkContext$.MODULE$.getOrCreate();
                    this.batch();
                }
                this.initMonitor();
                while (this.sparklyr$Backend$$isRunning.get()) {
                    this.bind();
                }
            }
            catch (SocketException e) {
                this.sparklyr$Backend$$logger.log("is shutting down with expected SocketException", e);
                if (this.sparklyr$Backend$$isService) break block5;
                System.exit(1);
            }
            catch (IOException e) {
                this.sparklyr$Backend$$logger.logError("is shutting down from run() with exception ", e);
                if (this.sparklyr$Backend$$isService) break block5;
                System.exit(1);
            }
        }
    }

    public void initMonitor() {
        new Thread(this){
            private final /* synthetic */ Backend $outer;

            public void run() {
                block2: {
                    String string;
                    Thread.sleep(this.$outer.sparklyr$Backend$$connectionTimeout * 1000);
                    if (this.$outer.sparklyr$Backend$$oneConnection.get() || this.$outer.sparklyr$Backend$$isService) break block2;
                    try {
                        string = new StringBuilder(5).append(" to ").append(InetAddress.getLocalHost().getHostAddress().toString()).append("/").append(this.$outer.getPort()).toString();
                    }
                    catch (UnknownHostException e) {
                        string = "unknown host";
                    }
                    String hostAddress = string;
                    this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(68).append("is terminating backend since no client has connected after ").append(this.$outer.sparklyr$Backend$$connectionTimeout).append(" seconds").append(hostAddress).append(".").toString());
                    System.exit(1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("starting init monitor thread");
            }
        }.start();
    }

    public void bind() {
        this.sparklyr$Backend$$logger.log(new StringBuilder(50).append("is waiting for sparklyr client to connect to port ").append(this.sparklyr$Backend$$port).toString());
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(this.sparklyr$Backend$$gatewayServerSocket.getInetAddress());
            if (!networkInterface.isUp()) {
                this.sparklyr$Backend$$logger.logError(new StringBuilder(199).append("Network interface of gateway server socket (").append(networkInterface.getName()).append(") is not up.\n\n'ifconfig ").append(networkInterface.getName()).append(" up' (or ").append("'netsh interface set interface name=").append(networkInterface.getName()).append(" admin=enabled' or ").append("similar in Windows) must be run to bring up this network interface.").toString());
                System.exit(1);
            }
        }
        catch (Throwable e) {
            this.sparklyr$Backend$$logger.logWarning(new StringBuilder(56).append("Failed to get network interface of gateway server socket").append(e.getMessage()).toString());
        }
        Socket gatewaySocket = this.sparklyr$Backend$$gatewayServerSocket.accept();
        this.sparklyr$Backend$$oneConnection.set(true);
        this.sparklyr$Backend$$logger.log("accepted connection");
        byte[] buf = new byte[1024];
        new Thread(this, gatewaySocket, buf){
            private final /* synthetic */ Backend $outer;
            public final Socket gatewaySocket$1;
            private final byte[] buf$1;

            public void run() {
                block20: {
                    try {
                        DataInputStream dis = new DataInputStream(this.gatewaySocket$1.getInputStream());
                        int commandId = dis.readInt();
                        this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(17).append("received command ").append(commandId).toString());
                        Enumeration.Value value = this.$outer.GatewayOperations().apply(commandId);
                        Enumeration.Value value2 = this.$outer.GatewayOperations().GetPorts();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            Object object;
                            int requestedSessionId = dis.readInt();
                            int startupTimeout = dis.readInt();
                            DataOutputStream dos = new DataOutputStream(this.gatewaySocket$1.getOutputStream());
                            if (requestedSessionId == this.$outer.sparklyr$Backend$$sessionId) {
                                int n;
                                this.$outer.sparklyr$Backend$$logger.log("found requested session matches current session");
                                this.$outer.sparklyr$Backend$$logger.log("is creating backend and allocating system resources");
                                JVMObjectTracker tracker = this.$outer.sparklyr$Backend$$defaultTracker.isDefined() ? (JVMObjectTracker)this.$outer.sparklyr$Backend$$defaultTracker.get() : new JVMObjectTracker();
                                Serializer serializer = new Serializer(tracker);
                                BackendChannel backendChannel = new BackendChannel(this.$outer.sparklyr$Backend$$logger, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.terminate(), serializer, tracker);
                                backendChannel.setHostContext(this.$outer.sparklyr$Backend$$hostContext);
                                int backendPort = backendChannel.init(this.$outer.sparklyr$Backend$$isRemote, this.$outer.sparklyr$Backend$$port, !this.$outer.sparklyr$Backend$$isWorker);
                                this.$outer.sparklyr$Backend$$logger.log("created the backend");
                                try {
                                    new Thread(this, dos, backendPort, backendChannel){
                                        private final /* synthetic */ $anon$3 $outer;
                                        private final DataOutputStream dos$1;
                                        private final int backendPort$1;
                                        private final BackendChannel backendChannel$1;

                                        public void run() {
                                            try {
                                                this.dos$1.writeInt(this.$outer.sparklyr$Backend$$anon$$$outer().sparklyr$Backend$$sessionId);
                                                this.dos$1.writeInt(this.$outer.gatewaySocket$1.getLocalPort());
                                                this.dos$1.writeInt(this.backendPort$1);
                                                this.backendChannel$1.run();
                                            }
                                            catch (IOException e) {
                                                this.$outer.sparklyr$Backend$$anon$$$outer().sparklyr$Backend$$logger.logError("failed with exception ", e);
                                                if (!this.$outer.sparklyr$Backend$$anon$$$outer().sparklyr$Backend$$isService) {
                                                    System.exit(1);
                                                }
                                                this.$outer.sparklyr$Backend$$anon$$$outer().terminate();
                                            }
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.dos$1 = dos$1;
                                            this.backendPort$1 = backendPort$1;
                                            this.backendChannel$1 = backendChannel$1;
                                            super("run backend");
                                            this.setDaemon(true);
                                        }
                                    }.start();
                                    this.$outer.sparklyr$Backend$$logger.log("is waiting for r process to end");
                                    n = this.gatewaySocket$1.getInputStream().read(this.buf$1);
                                }
                                finally {
                                    backendChannel.close();
                                    if (!this.$outer.sparklyr$Backend$$isService) {
                                        this.$outer.sparklyr$Backend$$logger.log("is terminating backend");
                                        this.$outer.sparklyr$Backend$$gatewayServerSocket.close();
                                        System.exit(0);
                                    }
                                    if (this.$outer.sparklyr$Backend$$isWorker) {
                                        this.$outer.sparklyr$Backend$$logger.log("is terminating backend");
                                        this.$outer.sparklyr$Backend$$isRunning.set(false);
                                        this.$outer.sparklyr$Backend$$gatewayServerSocket.close();
                                    }
                                }
                                object = BoxesRunTime.boxToInteger((int)n);
                            } else {
                                this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(25).append("is searching for session ").append(requestedSessionId).toString());
                                Option portForSession = this.$outer.sparklyr$Backend$$sessionsMap.get((Object)BoxesRunTime.boxToInteger((int)requestedSessionId));
                                for (int sessionMapRetries = startupTimeout * 10; !portForSession.isDefined() && sessionMapRetries > 0; --sessionMapRetries) {
                                    portForSession = this.$outer.sparklyr$Backend$$sessionsMap.get((Object)BoxesRunTime.boxToInteger((int)requestedSessionId));
                                    Thread.sleep(100L);
                                }
                                if (portForSession.isDefined()) {
                                    this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(26).append("found mapping for session ").append(requestedSessionId).toString());
                                    dos.writeInt(requestedSessionId);
                                    dos.writeInt(BoxesRunTime.unboxToInt((Object)portForSession.get()));
                                    dos.writeInt(0);
                                } else {
                                    this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(29).append("found no mapping for session ").append(requestedSessionId).toString());
                                    dos.writeInt(requestedSessionId);
                                    dos.writeInt(0);
                                    dos.writeInt(0);
                                }
                                object = BoxedUnit.UNIT;
                            }
                            dos.close();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Enumeration.Value value4 = this.$outer.GatewayOperations().RegisterInstance();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                int registerSessionId = dis.readInt();
                                int registerGatewayPort = dis.readInt();
                                this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(38).append("received session ").append(registerSessionId).append(" registration request").toString());
                                this.$outer.sparklyr$Backend$$sessionsMap = this.$outer.sparklyr$Backend$$sessionsMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)registerSessionId)), (Object)BoxesRunTime.boxToInteger((int)registerGatewayPort)));
                                DataOutputStream dos = new DataOutputStream(this.gatewaySocket$1.getOutputStream());
                                dos.writeInt(0);
                                dos.flush();
                                dos.close();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                Enumeration.Value value6 = this.$outer.GatewayOperations().UnregisterInstance();
                                Enumeration.Value value7 = value;
                                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                    int unregisterSessionId = dis.readInt();
                                    this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(40).append("received session ").append(unregisterSessionId).append(" unregistration request").toString());
                                    if (this.$outer.sparklyr$Backend$$sessionsMap.contains((Object)BoxesRunTime.boxToInteger((int)unregisterSessionId))) {
                                        this.$outer.sparklyr$Backend$$logger.log(new StringBuilder(44).append("found session ").append(unregisterSessionId).append(" during unregistration request").toString());
                                        this.$outer.sparklyr$Backend$$sessionsMap = (Map)this.$outer.sparklyr$Backend$$sessionsMap.$minus((Object)BoxesRunTime.boxToInteger((int)unregisterSessionId));
                                    }
                                    DataOutputStream dos = new DataOutputStream(this.gatewaySocket$1.getOutputStream());
                                    dos.writeInt(0);
                                    dos.flush();
                                    dos.close();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                        this.gatewaySocket$1.close();
                    }
                    catch (IOException e) {
                        this.$outer.sparklyr$Backend$$logger.logError("failed with exception ", e);
                        if (this.$outer.sparklyr$Backend$$isService) break block20;
                        System.exit(1);
                    }
                }
            }

            public /* synthetic */ Backend sparklyr$Backend$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gatewaySocket$1 = gatewaySocket$1;
                this.buf$1 = buf$1;
                super("wait for monitor to close");
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(sparklyr.Backend$$anon$3 )}, serializedLambda);
            }
        }.start();
    }

    public boolean register(int gatewayPort, int sessionId, int port) {
        this.sparklyr$Backend$$logger.log("is registering session in gateway");
        Socket s = new Socket(InetAddress.getLoopbackAddress(), gatewayPort);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        dos.writeInt(this.GatewayOperations().RegisterInstance().id());
        dos.writeInt(sessionId);
        dos.writeInt(port);
        this.sparklyr$Backend$$logger.log("is waiting for registration in gateway");
        DataInputStream dis = new DataInputStream(s.getInputStream());
        int status = dis.readInt();
        this.sparklyr$Backend$$logger.log(new StringBuilder(45).append("finished registration in gateway with status ").append(status).toString());
        s.close();
        return status == 0;
    }

    public void terminate() {
        block2: {
            boolean success;
            if (this.isRegistered && !this.sparklyr$Backend$$isWorker && !(success = this.unregister(this.gatewayPort, this.sparklyr$Backend$$sessionId))) {
                this.sparklyr$Backend$$logger.logError(new StringBuilder(37).append("failed to unregister on gateway port ").append(this.gatewayPort).toString());
                if (!this.sparklyr$Backend$$isService) {
                    System.exit(1);
                }
            }
            if (this.sparklyr$Backend$$isService && !this.sparklyr$Backend$$isWorker) break block2;
            this.sparklyr$Backend$$isRunning.set(false);
            this.sparklyr$Backend$$gatewayServerSocket.close();
        }
    }

    public boolean unregister(int gatewayPort, int sessionId) {
        boolean bl;
        block3: {
            try {
                this.sparklyr$Backend$$logger.log("is unregistering session in gateway");
                Socket s = new Socket(InetAddress.getLoopbackAddress(), gatewayPort);
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeInt(this.GatewayOperations().UnregisterInstance().id());
                dos.writeInt(sessionId);
                this.sparklyr$Backend$$logger.log("is waiting for unregistration in gateway");
                DataInputStream dis = new DataInputStream(s.getInputStream());
                int status = dis.readInt();
                this.sparklyr$Backend$$logger.log(new StringBuilder(47).append("finished unregistration in gateway with status ").append(status).toString());
                s.close();
                if (status == 0) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.sparklyr$Backend$$logger.log(new StringBuilder(35).append("failed to unregister from gateway: ").append(e.toString()).toString());
                bl = false;
            }
        }
        return bl;
    }

    private final void GatewayOperations$lzycompute$1() {
        Backend backend = this;
        synchronized (backend) {
            if (this.GatewayOperations$module == null) {
                this.GatewayOperations$module = new Backend$GatewayOperations$(this);
            }
        }
    }
}

