% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_avro}
\alias{spark_write_avro}
\title{Serialize a Spark DataFrame into Apache Avro format}
\usage{
spark_write_avro(
  x,
  path,
  avro_schema = NULL,
  record_name = "topLevelRecord",
  record_namespace = "",
  compression = "snappy",
  partition_by = NULL
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{avro_schema}{Optional Avro schema in JSON format}

\item{record_name}{Optional top level record name in write result (default: "topLevelRecord")}

\item{record_namespace}{Record namespace in write result (default: "")}

\item{compression}{Compression codec to use (default: "snappy")}

\item{partition_by}{A \code{character} vector. Partitions the output by the given columns on the file system.}
}
\description{
Serialize a Spark DataFrame into Apache Avro format.
Notice this functionality requires the Spark connection \code{sc} to be instantiated with either
an explicitly specified Spark version (i.e.,
\code{spark_connect(..., version = <version>, packages = c("avro", <other package(s)>), ...)})
or a specific version of Spark avro package to use (e.g.,
\code{spark_connect(..., packages = c("org.apache.spark:spark-avro_2.12:3.0.0", <other package(s)>), ...)}).
}
\seealso{
Other Spark serialization routines: 
\code{\link{spark_load_table}()},
\code{\link{spark_read_avro}()},
\code{\link{spark_read_csv}()},
\code{\link{spark_read_delta}()},
\code{\link{spark_read_jdbc}()},
\code{\link{spark_read_json}()},
\code{\link{spark_read_libsvm}()},
\code{\link{spark_read_orc}()},
\code{\link{spark_read_parquet}()},
\code{\link{spark_read_source}()},
\code{\link{spark_read_table}()},
\code{\link{spark_read_text}()},
\code{\link{spark_read}()},
\code{\link{spark_save_table}()},
\code{\link{spark_write_csv}()},
\code{\link{spark_write_delta}()},
\code{\link{spark_write_jdbc}()},
\code{\link{spark_write_json}()},
\code{\link{spark_write_orc}()},
\code{\link{spark_write_parquet}()},
\code{\link{spark_write_source}()},
\code{\link{spark_write_table}()},
\code{\link{spark_write_text}()}
}
\concept{Spark serialization routines}
