% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_read_scoket}
\alias{stream_read_scoket}
\title{Read Socket Stream}
\usage{
stream_read_scoket(sc, name = NULL, columns = NULL, options = list(),
  ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{name}{The name to assign to the newly generated stream.}

\item{columns}{A vector of column names or a named vector of column types.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Reads a Socket stream as a Spark dataframe stream.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

# Start socket server from terminal, example: nc -lk 9999
stream <- stream_read_scoket(sc, options = list(host = "localhost", port = 9999))
stream

}

}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_kafka}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_parquet}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_console}},
  \code{\link{stream_write_csv}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_parquet}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
