% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_spark.R
\name{spark-connections}
\alias{spark-connections}
\alias{spark-connections}
\alias{spark_connect}
\alias{spark-connections}
\alias{spark_connection_is_open}
\alias{spark-connections}
\alias{spark_disconnect}
\alias{spark-connections}
\alias{spark_disconnect_all}
\title{Manage Spark Connections}
\usage{
spark_connect(master, spark_home = Sys.getenv("SPARK_HOME"),
  method = c("shell", "livy", "test"), app_name = "sparklyr",
  version = NULL, hadoop_version = NULL, config = spark_config(),
  extensions = sparklyr::registered_extensions())

spark_connection_is_open(sc)

spark_disconnect(sc, ...)

spark_disconnect_all()
}
\arguments{
\item{master}{Spark cluster url to connect to. Use \code{"local"} to
connect to a local instance of Spark installed via
\code{\link{spark_install}}.}

\item{spark_home}{The path to a Spark installation. Defaults to the path
provided by the \code{SPARK_HOME} environment variable. If
\code{SPARK_HOME} is defined, it will be always be used unless the
\code{version} parameter is specified to force the use of a locally
installed version.}

\item{method}{The method used to connect to Spark. Currently, only
\code{"shell"} is supported.}

\item{app_name}{The application name to be used while running in the Spark
cluster.}

\item{version}{The version of Spark to use. Only applicable to
\code{"local"} Spark connections.}

\item{hadoop_version}{The version of Hadoop to use. Only applicable to
\code{"local"} Spark connections.}

\item{config}{Custom configuration for the generated Spark connection. See
\code{\link{spark_config}} for details.}

\item{extensions}{Extension packages to enable for this connection. By
default, all packages enabled through the use of
\code{\link[=register_extension]{sparklyr::register_extension}} will be passed here.}

\item{sc}{A \code{spark_connection}.}

\item{...}{Optional arguments; currently unused.}
}
\description{
These routines allow you to manage your connections to Spark.
}
\examples{

sc <- spark_connect(master = "spark://HOST:PORT")
connection_is_open(sc)

spark_disconnect(sc)

}
