% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_utils.R
\name{collect.ts_rdd}
\alias{collect.ts_rdd}
\title{Collect data from a TimeSeriesRDD}
\usage{
\method{collect}{ts_rdd}(x, ...)
}
\arguments{
\item{x}{A com.twosigma.flint.timeseries.TimeSeriesRDD object}

\item{...}{Additional arguments to `sdf_collect()`}
}
\value{
A R data frame containing the same time series data the input
  TimeSeriesRDD contains
}
\description{
Collect data from a TimeSeriesRDD into a R data frame
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = seq(10)))
  ts <- from_sdf(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  df <- ts \%>\% collect()
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other Spark dataframe utility functions: 
\code{\link{from_rdd}()},
\code{\link{from_sdf}()},
\code{\link{spark_connection.ts_rdd}()},
\code{\link{spark_dataframe.ts_rdd}()},
\code{\link{spark_jobj.ts_rdd}()},
\code{\link{to_sdf}()},
\code{\link{ts_rdd_builder}()}
}
\concept{Spark dataframe utility functions}
