% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{.analyze}
\alias{.analyze}
\title{Analyze per sound}
\usage{
.analyze(
  audio,
  dynamicRange = 80,
  silence = 0.04,
  windowLength = 50,
  step = 25,
  overlap = 50,
  specType = c("spectrum", "reassign", "spectralDerivative")[1],
  wn = "gaussian",
  zp = 0,
  cutFreq = NULL,
  nFormants = 3,
  formants = NULL,
  loudness = NULL,
  roughness = NULL,
  novelty = NULL,
  pitchMethods = c("dom", "autocor"),
  pitchManual_list = NULL,
  entropyThres = 0.6,
  pitchFloor = 75,
  pitchCeiling = 3500,
  priorMean = 300,
  priorSD = 6,
  priorAdapt = TRUE,
  nCands = 1,
  minVoicedCands = NULL,
  pitchDom = list(domThres = 0.1, domSmooth = 220),
  pitchAutocor = list(autocorThres = 0.7, autocorSmooth = 7, autocorUpsample = 25,
    autocorBestPeak = 0.975),
  pitchCep = list(cepThres = 0.75, cepZp = 0),
  pitchSpec = list(specThres = 0.05, specPeak = 0.25, specHNRslope = 0.8, specSmooth =
    150, specMerge = 0.1, specSinglePeakCert = 0.4, specRatios = 3),
  pitchHps = list(hpsNum = 5, hpsThres = 0.1, hpsNorm = 2, hpsPenalty = 2),
  pitchZc = list(zcThres = 0.1, zcWin = 5),
  harmHeight = list(harmThres = 3, harmTol = 0.25, harmPerSel = 5),
  subh = list(method = c("cep", "pitchCands", "harm")[1], nSubh = 5, tol = 0.05, nHarm =
    5, harmThres = 12, harmTol = 0.25, amRange = c(10, 200)),
  flux = list(thres = 0.15, smoothWin = 100),
  amRange = c(10, 200),
  fmRange = c(5, 1000/step/2),
  shortestSyl = 20,
  shortestPause = 60,
  interpol = NULL,
  pathfinding = c("none", "fast", "slow")[2],
  annealPars = list(maxit = 5000, temp = 1000),
  certWeight = 0.5,
  snakeStep = 0,
  snakePlot = FALSE,
  smooth = 1,
  smoothVars = c("pitch", "dom"),
  returnPitchCands = FALSE,
  plot = TRUE,
  showLegend = TRUE,
  osc = "linear",
  pitchPlot = list(col = rgb(0, 0, 1, 0.75), lwd = 3, showPrior = TRUE),
  pitchDom_plotPars = list(),
  pitchAutocor_plotPars = list(),
  pitchCep_plotPars = list(),
  pitchSpec_plotPars = list(),
  pitchHps_plotPars = list(),
  pitchZc_plotPars = list(),
  extraContour = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{silence}{(0 to 1 as proportion of max amplitude) frames with RMS
amplitude below \code{silence * max_ampl adjusted by scale} are not
analyzed at all.}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{specType}{plot the original FFT ('spectrum'), reassigned spectrogram
('reassigned'), or spectral derivative ('spectralDerivative')}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{cutFreq}{if specified, spectral descriptives (peakFreq, specCentroid,
specSlope, and quartiles) are calculated only between \code{cutFreq[1]} and
\code{cutFreq[2]}, Hz. If a single number is given, analyzes frequencies
from 0 to \code{cutFreq}. For ex., when analyzing recordings with varying
sampling rates, set to half the lowest sampling rate to make the spectra
more comparable. Note that "entropyThres" applies only to this frequency
range, which also affects which frames will not be analyzed with
pitchAutocor.}

\item{nFormants}{the number of formants to extract per STFT frame (0 = no
formant analysis, NULL = as many as possible)}

\item{formants}{a list of arguments passed to
\code{\link[phonTools]{findformants}} - an external function called to
perform LPC analysis}

\item{loudness}{a list of parameters passed to \code{\link{getLoudness}} for
measuring subjective loudness, namely \code{SPL_measured, Pref,
spreadSpectrum}. NULL = skip loudness analysis}

\item{roughness}{a list of parameters passed to
\code{\link{modulationSpectrum}} for measuring roughness. NULL = skip
roughness analysis}

\item{novelty}{a list of parameters passed to \code{\link{ssm}} for measuring
spectral novelty. NULL = skip novelty analysis}

\item{pitchMethods}{methods of pitch estimation to consider for determining
pitch contour: 'autocor' = autocorrelation (~PRAAT), 'cep' = cepstral,
'spec' = spectral (~BaNa), 'dom' = lowest dominant frequency band, 'hps' =
harmonic product spectrum, NULL = no pitch analysis}

\item{entropyThres}{pitch tracking is only performed for frames with Weiner
entropy below \code{entropyThres}, but other spectral descriptives are
still calculated (NULL = analyze everything)}

\item{pitchFloor, pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{priorMean, priorSD}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave)}

\item{priorAdapt}{adaptive second-pass prior: if TRUE, optimal pitch contours
are estimated first with a prior determined by \code{priorMean,priorSD}, and
then with a new prior adjusted according to this first-pass pitch contour}

\item{nCands}{maximum number of pitch candidates per method, normally 1...4
(except for \code{dom}, which returns at most one candidate per frame)}

\item{minVoicedCands}{minimum number of pitch candidates that have to be
defined to consider a frame voiced (if NULL, defaults to 2 if \code{dom} is
among other candidates and 1 otherwise)}

\item{pitchDom}{a list of control parameters for pitch tracking using the
lowest dominant frequency band or "dom" method; see details and
\code{?soundgen:::getDom}}

\item{pitchAutocor}{a list of control parameters for pitch tracking using the
autocorrelation or "autocor" method; see details and
\code{?soundgen:::getPitchAutocor}}

\item{pitchCep}{a list of control parameters for pitch tracking using the
cepstrum or "cep" method; see details and \code{?soundgen:::getPitchCep}}

\item{pitchSpec}{a list of control parameters for pitch tracking using the
BaNa or "spec" method; see details and \code{?soundgen:::getPitchSpec}}

\item{pitchHps}{a list of control parameters for pitch tracking using the
harmonic product spectrum or "hps" method; see details and
\code{?soundgen:::getPitchHps}}

\item{pitchZc}{a list of control parameters for pitch tracking based on zero
crossings in bandpass-filtered audio or "zc" method; see
\code{\link{getPitchZc}}}

\item{harmHeight}{a list of control parameters for estimating how high
harmonics reach in the spectrum; see details and \code{?soundgen:::harmHeight}}

\item{subh}{a list of control parameters for estimating the strength of
subharmonics per frame - that is, spectral energy at integer ratios of f0:
see \code{?soundgen:::subhToHarm}}

\item{flux}{a list of control parameters for calculating feature-based flux
(not spectral flux) passed to \code{\link{getFeatureFlux}}}

\item{amRange}{target range of frequencies for amplitude modulation, Hz: a
vector of length 2 (affects both \code{amMsFreq} and \code{amEnvFreq})}

\item{fmRange}{target range of frequencies for analyzing frequency
modulation, Hz (\code{fmFreq}): a vector of length 2}

\item{shortestSyl}{the smallest length of a voiced segment (ms) that
constitutes a voiced syllable (shorter segments will be replaced by NA, as
if unvoiced)}

\item{shortestPause}{the smallest gap between voiced syllables (ms): large
value = interpolate and merge, small value = treat as separate syllables
separated by an unvoiced gap}

\item{interpol}{a list of parameters (currently \code{win, tol, cert}) passed
to \code{soundgen:::pathfinder} for interpolating missing pitch candidates
(NULL = no interpolation)}

\item{pathfinding}{method of finding the optimal path through pitch
candidates: 'none' = best candidate per frame, 'fast' = simple heuristic,
'slow' = annealing. See \code{soundgen:::pathfinder}}

\item{annealPars}{a list of control parameters for postprocessing of
pitch contour with SANN algorithm of \code{\link[stats]{optim}}. This is
only relevant if \code{pathfinding = 'slow'}}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{snakeStep}{optimized path through pitch candidates is further
processed to minimize the elastic force acting on pitch contour. To
disable, set \code{snakeStep = 0}}

\item{snakePlot}{if TRUE, plots the snake}

\item{smooth, smoothVars}{if \code{smooth} is a positive number, outliers of
the variables in \code{smoothVars} are adjusted with median smoothing.
\code{smooth} of 1 corresponds to a window of ~100 ms and tolerated
deviation of ~4 semitones. To disable, set \code{smooth = 0}}

\item{plot}{if TRUE, produces a spectrogram with pitch contour overlaid}

\item{showLegend}{if TRUE, adds a legend with pitch tracking methods}

\item{osc}{"none" = no oscillogram; "linear" = on the original scale; "dB" =
in decibels}

\item{pitchPlot}{a list of graphical parameters for displaying the final
pitch contour. Set to \code{list(type = 'n')} to suppress}

\item{extraContour}{name of an output variable to overlap on the pitch
contour plot, eg 'peakFreq' or 'loudness'; can also be a list with extra
graphical parameters, eg \code{extraContour = list(x = 'harmHeight', col =
'red')}}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist
frequency). NB: still in kHz, even if yScale = bark, mel, or ERB}

\item{xlab, ylab, main}{plotting parameters}

\item{width, height, units, res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{...}{other graphical parameters passed to \code{\link{spectrogram}}}
}
\description{
Internal soundgen function
}
\details{
Called by \code{\link{analyze}} and \code{\link{pitch_app}} to analyze a
single sound.
}
\keyword{internal}
