% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prosody.R
\name{.prosody}
\alias{.prosody}
\title{Prosody per sound}
\usage{
.prosody(
  audio,
  multProsody,
  analyze_pars = list(),
  shiftPitch_pars = list(),
  pitchManual_list = NULL,
  play = FALSE,
  plot = FALSE,
  savePlots = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{multProsody}{multiplier of pitch excursion from median (on a
logarithmic or musical scale): >1 = exaggerate intonation, 1 = no change, <1
= flatten, 0 = completely flat at the original median pitch}

\item{analyze_pars}{a list of parameters to pass to \code{\link{analyze}}
(only needed if \code{pitchManual} is NULL - that is, if we attempt to
track pitch automatically)}

\item{shiftPitch_pars}{a list of parameters to pass to
\code{\link{shiftPitch}} to fine-tune the pitch-shifting algorithm}

\item{play}{if TRUE, plays the processed audio}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function called by \code{\link{prosody}}
}
\keyword{internal}
