% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{loadSampleDataset}
\alias{loadSampleDataset}
\title{Load one of \code{\link{soundcorrs}}' sample datasets.}
\usage{
loadSampleDataset(x)
}
\arguments{
\item{x}{[character] Name of the dataset to load. Available sets are: \code{\link{soundchange}}'s: \code{change-dl2l}, \code{change-palatalization}, \code{change-rhotacism}; \code{\link{soundcorrs}}'s: \code{data-abc}, \code{data-capitals}, \code{data-ie}; and \code{\link{transcription}}'s: \code{trans-common}, \code{trans-ipa}.}
}
\value{
[soundchange/soundcorrs/transcription] The selected sample dataset.
}
\description{
Retrieve and return one the sample datasets included in \code{\link{soundcorrs}}.
}
\details{
R does not allow non-ASCII characters in preloaded datasets, and linguistic datasets can hardly fit within ASCII. Unicode is, however, allowed in raw data files. They cannot be automatically loaded when \code{\link{soundcorrs}} is attached because staged install makes it impossible to use \code{\link{system.file}} in this manner, and they cannot be included as a Unicode-escaped output of \code{\link{dput}} because Windows does not know how to convert this to its native encoding. This function makes the process of loading as painless as possible.
}
\examples{
loadSampleDataset ("data-abc")
loadSampleDataset ("trans-ipa")
loadSampleDataset ("change-palatalization")
}
